/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas;

import com.codahale.metrics.annotation.Counted;
import com.codahale.metrics.annotation.Metered;
import com.codahale.metrics.annotation.Timed;
import java.io.Serializable;
import java.util.Collection;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import lombok.NonNull;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.CipherExecutor;
import org.apereo.cas.audit.AuditableExecution;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.authentication.ContextualAuthenticationPolicy;
import org.apereo.cas.authentication.ContextualAuthenticationPolicyFactory;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.logout.LogoutManager;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServiceContext;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.services.UnauthorizedProxyingException;
import org.apereo.cas.ticket.AbstractTicketException;
import org.apereo.cas.ticket.InvalidTicketException;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketFactory;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.UnsatisfiedAuthenticationPolicyException;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

public abstract class AbstractCentralAuthenticationService
implements CentralAuthenticationService,
Serializable,
ApplicationEventPublisherAware {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractCentralAuthenticationService.class);
    @Generated
    private final Object $lock = new Object[0];
    private static final long serialVersionUID = -7572316677901391166L;
    protected ApplicationEventPublisher applicationEventPublisher;
    protected final TicketRegistry ticketRegistry;
    protected final ServicesManager servicesManager;
    protected final LogoutManager logoutManager;
    protected final TicketFactory ticketFactory;
    protected final AuthenticationServiceSelectionPlan authenticationRequestServiceSelectionStrategies;
    protected final ContextualAuthenticationPolicyFactory<ServiceContext> serviceContextAuthenticationPolicyFactory;
    protected final PrincipalFactory principalFactory;
    protected final CipherExecutor<String, String> cipherExecutor;
    protected final AuditableExecution registeredServiceAccessStrategyEnforcer;

    protected void doPublishEvent(ApplicationEvent e) {
        if (this.applicationEventPublisher != null) {
            LOGGER.debug("Publishing [{}]", (Object)e);
            this.applicationEventPublisher.publishEvent(e);
        }
    }

    @Transactional(transactionManager="ticketTransactionManager", noRollbackFor={InvalidTicketException.class})
    @Timed(name="GET_TICKET_TIMER")
    @Metered(name="GET_TICKET_METER")
    @Counted(name="GET_TICKET_COUNTER", monotonic=true)
    public Ticket getTicket(@NonNull String ticketId) throws InvalidTicketException {
        if (ticketId == null) {
            throw new NullPointerException("ticketId is marked @NonNull but is null");
        }
        Ticket ticket = this.ticketRegistry.getTicket(ticketId);
        this.verifyTicketState(ticket, ticketId, null);
        return ticket;
    }

    @Transactional(transactionManager="ticketTransactionManager", noRollbackFor={InvalidTicketException.class})
    @Timed(name="GET_TICKET_TIMER")
    @Metered(name="GET_TICKET_METER")
    @Counted(name="GET_TICKET_COUNTER", monotonic=true)
    public <T extends Ticket> T getTicket(@NonNull String ticketId, Class<T> clazz) throws InvalidTicketException {
        if (ticketId == null) {
            throw new NullPointerException("ticketId is marked @NonNull but is null");
        }
        Ticket ticket = this.ticketRegistry.getTicket(ticketId, clazz);
        this.verifyTicketState(ticket, ticketId, clazz);
        return (T)ticket;
    }

    @Transactional(transactionManager="ticketTransactionManager")
    @Timed(name="GET_TICKETS_TIMER")
    @Metered(name="GET_TICKETS_METER")
    @Counted(name="GET_TICKETS_COUNTER", monotonic=true)
    public Collection<Ticket> getTickets(Predicate<Ticket> predicate) {
        try (Stream<Ticket> ticketsStream = this.ticketRegistry.getTicketsStream().filter(predicate);){
            Collection collection = ticketsStream.collect(Collectors.toSet());
            return collection;
        }
    }

    @Transactional(transactionManager="ticketTransactionManager")
    @Timed(name="DELETE_TICKET_TIMER")
    @Metered(name="DELETE_TICKET_METER")
    @Counted(name="DELETE_TICKET_COUNTER", monotonic=true)
    public void deleteTicket(String ticketId) {
        this.ticketRegistry.deleteTicket(ticketId);
    }

    protected Authentication getAuthenticationSatisfiedByPolicy(Authentication authentication, ServiceContext context) throws AbstractTicketException {
        ContextualAuthenticationPolicy policy = this.serviceContextAuthenticationPolicyFactory.createPolicy((Object)context);
        try {
            if (policy.isSatisfiedBy(authentication)) {
                return authentication;
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        throw new UnsatisfiedAuthenticationPolicyException(policy);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void evaluateProxiedServiceIfNeeded(Service service, TicketGrantingTicket ticketGrantingTicket, RegisteredService registeredService) {
        Service proxiedBy = ticketGrantingTicket.getProxiedBy();
        if (proxiedBy != null) {
            LOGGER.debug("TGT is proxied by [{}]. Locating proxy service in registry...", (Object)proxiedBy.getId());
            RegisteredService proxyingService = this.servicesManager.findServiceBy(proxiedBy);
            if (proxyingService != null) {
                LOGGER.debug("Located proxying service [{}] in the service registry", (Object)proxyingService);
                if (proxyingService.getProxyPolicy().isAllowedToProxy()) return;
                LOGGER.warn("Found proxying service [{}], but it is not authorized to fulfill the proxy attempt made by [{}]", (Object)proxyingService.getId(), (Object)service.getId());
                throw new UnauthorizedProxyingException("Proxying is not allowed for registered service " + registeredService.getId());
            }
            LOGGER.warn("No proxying service found. Proxy attempt by service [{}] (registered service [{}]) is not allowed.", (Object)service.getId(), (Object)registeredService.getId());
            throw new UnauthorizedProxyingException("Proxying is not allowed for registered service " + registeredService.getId());
        }
        LOGGER.trace("TGT is not proxied by another service");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void verifyTicketState(Ticket ticket, String id, Class clazz) {
        Object object = this.$lock;
        synchronized (object) {
            if (ticket == null) {
                LOGGER.debug("Ticket [{}] by type [{}] cannot be found in the ticket registry.", (Object)id, (Object)(clazz != null ? clazz.getSimpleName() : "unspecified"));
                throw new InvalidTicketException(id);
            }
            if (ticket.isExpired()) {
                this.deleteTicket(id);
                LOGGER.debug("Ticket [{}] has expired and is now deleted from the ticket registry.", (Object)ticket);
                throw new InvalidTicketException(id);
            }
        }
    }

    public Ticket updateTicket(Ticket ticket) {
        this.ticketRegistry.updateTicket(ticket);
        return ticket;
    }

    protected Service resolveServiceFromAuthenticationRequest(Service service) {
        return this.authenticationRequestServiceSelectionStrategies.resolveService(service);
    }

    protected boolean isTicketAuthenticityVerified(String ticketId) {
        if (this.cipherExecutor != null) {
            LOGGER.debug("Attempting to decode service ticket [{}] to verify authenticity", (Object)ticketId);
            return !StringUtils.isEmpty((Object)this.cipherExecutor.decode((Object)ticketId));
        }
        return !StringUtils.isEmpty((Object)ticketId);
    }

    @Generated
    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    @Generated
    public AbstractCentralAuthenticationService(ApplicationEventPublisher applicationEventPublisher, TicketRegistry ticketRegistry, ServicesManager servicesManager, LogoutManager logoutManager, TicketFactory ticketFactory, AuthenticationServiceSelectionPlan authenticationRequestServiceSelectionStrategies, ContextualAuthenticationPolicyFactory<ServiceContext> serviceContextAuthenticationPolicyFactory, PrincipalFactory principalFactory, CipherExecutor<String, String> cipherExecutor, AuditableExecution registeredServiceAccessStrategyEnforcer) {
        this.applicationEventPublisher = applicationEventPublisher;
        this.ticketRegistry = ticketRegistry;
        this.servicesManager = servicesManager;
        this.logoutManager = logoutManager;
        this.ticketFactory = ticketFactory;
        this.authenticationRequestServiceSelectionStrategies = authenticationRequestServiceSelectionStrategies;
        this.serviceContextAuthenticationPolicyFactory = serviceContextAuthenticationPolicyFactory;
        this.principalFactory = principalFactory;
        this.cipherExecutor = cipherExecutor;
        this.registeredServiceAccessStrategyEnforcer = registeredServiceAccessStrategyEnforcer;
    }
}

