/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.core;

import java.util.Date;
import java.util.Set;
import org.fluentlenium.configuration.Configuration;
import org.fluentlenium.core.AbstractFluentDriverSearchControl;
import org.fluentlenium.core.FluentControl;
import org.fluentlenium.core.FluentDriverHtmlDumper;
import org.fluentlenium.core.FluentDriverScreenshotPersister;
import org.fluentlenium.core.FluentDriverTimeoutConfigurer;
import org.fluentlenium.core.FluentDriverWait;
import org.fluentlenium.core.FluentDriverWrappedCapabilitiesProvider;
import org.fluentlenium.core.FluentPage;
import org.fluentlenium.core.action.KeyboardActions;
import org.fluentlenium.core.action.MouseActions;
import org.fluentlenium.core.action.WindowAction;
import org.fluentlenium.core.alert.Alert;
import org.fluentlenium.core.alert.AlertImpl;
import org.fluentlenium.core.components.ComponentsManager;
import org.fluentlenium.core.css.CssControl;
import org.fluentlenium.core.css.CssControlImpl;
import org.fluentlenium.core.css.CssSupport;
import org.fluentlenium.core.domain.ElementUtils;
import org.fluentlenium.core.domain.FluentList;
import org.fluentlenium.core.domain.FluentWebElement;
import org.fluentlenium.core.events.ComponentsEventsRegistry;
import org.fluentlenium.core.events.EventsRegistry;
import org.fluentlenium.core.inject.ContainerContext;
import org.fluentlenium.core.inject.DefaultContainerInstantiator;
import org.fluentlenium.core.inject.FluentInjector;
import org.fluentlenium.core.performance.DefaultPerformanceTiming;
import org.fluentlenium.core.performance.PerformanceTiming;
import org.fluentlenium.core.script.FluentJavascript;
import org.fluentlenium.core.search.Search;
import org.fluentlenium.core.search.SearchFilter;
import org.fluentlenium.core.wait.FluentWait;
import org.fluentlenium.utils.Preconditions;
import org.fluentlenium.utils.UrlUtils;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Cookie;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.WrapsElement;
import org.openqa.selenium.support.events.EventFiringWebDriver;

public class FluentDriver
extends AbstractFluentDriverSearchControl {
    private final Configuration configuration;
    private final ComponentsManager componentsManager;
    private final EventsRegistry events;
    private final ComponentsEventsRegistry componentsEventsRegistry;
    private final FluentInjector fluentInjector;
    private final CssControl cssControl;
    private final Search search;
    private final WebDriver driver;
    private final MouseActions mouseActions;
    private final KeyboardActions keyboardActions;
    private final WindowAction windowAction;
    private final FluentDriverScreenshotPersister screenshotPersister;
    private final FluentDriverWrappedCapabilitiesProvider capabilitiesProvider;
    private final FluentDriverHtmlDumper htmlDumper;
    private final FluentDriverWait driverWait;
    private final PerformanceTiming performanceTiming;

    public FluentDriver(WebDriver driver, Configuration configuration, FluentControl adapter) {
        super(adapter);
        this.configuration = configuration;
        this.screenshotPersister = new FluentDriverScreenshotPersister(configuration, driver);
        this.capabilitiesProvider = new FluentDriverWrappedCapabilitiesProvider();
        this.htmlDumper = new FluentDriverHtmlDumper(configuration);
        this.componentsManager = new ComponentsManager(adapter);
        this.driverWait = new FluentDriverWait(configuration);
        this.driver = driver;
        this.search = new Search((SearchContext)driver, this, this.componentsManager, adapter);
        if (driver instanceof EventFiringWebDriver) {
            this.events = new EventsRegistry(this);
            this.componentsEventsRegistry = new ComponentsEventsRegistry(this.events, this.componentsManager);
        } else {
            this.events = null;
            this.componentsEventsRegistry = null;
        }
        this.mouseActions = new MouseActions(driver);
        this.keyboardActions = new KeyboardActions(driver);
        this.fluentInjector = new FluentInjector(adapter, this.events, this.componentsManager, new DefaultContainerInstantiator(this));
        this.cssControl = new CssControlImpl(adapter, adapter);
        this.windowAction = new WindowAction(adapter, this.componentsManager.getInstantiator(), driver);
        this.performanceTiming = new DefaultPerformanceTiming(driver);
        new FluentDriverTimeoutConfigurer(configuration, driver).configureDriver();
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    public void takeHtmlDump() {
        this.takeHtmlDump(new Date().getTime() + ".html");
    }

    @Override
    public void takeHtmlDump(String fileName) {
        this.htmlDumper.takeHtmlDump(fileName, () -> {
            Class<FluentDriver> clazz = FluentDriver.class;
            synchronized (FluentDriver.class) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return ((FluentWebElement)this.$("html", new SearchFilter[0]).first()).html();
            }
        });
    }

    @Override
    public boolean canTakeScreenShot() {
        return this.getDriver() instanceof TakesScreenshot;
    }

    @Override
    public void takeScreenshot() {
        this.takeScreenshot(new Date().getTime() + ".png");
    }

    @Override
    public void takeScreenshot(String fileName) {
        if (!this.canTakeScreenShot()) {
            throw new WebDriverException("Current browser doesn't allow taking screenshot.");
        }
        this.screenshotPersister.persistScreenshot(fileName);
    }

    @Override
    public WebDriver getDriver() {
        return this.driver;
    }

    @Override
    public EventsRegistry events() {
        return Preconditions.checkState(this.events, "An EventFiringWebDriver instance is required to use events. You should set 'eventsEnabled' configuration property to 'true' or override newWebDriver() to build an EventFiringWebDriver.");
    }

    @Override
    public MouseActions mouse() {
        return this.mouseActions;
    }

    @Override
    public KeyboardActions keyboard() {
        return this.keyboardActions;
    }

    @Override
    public WindowAction window() {
        return this.windowAction;
    }

    @Override
    public FluentWait await() {
        return this.driverWait.await(this);
    }

    @Override
    public Set<Cookie> getCookies() {
        return this.getDriver().manage().getCookies();
    }

    @Override
    public Cookie getCookie(String name) {
        return this.getDriver().manage().getCookieNamed(name);
    }

    @Override
    public String url() {
        String baseUrl = this.buildUrl(null);
        String currentUrl = this.getDriver().getCurrentUrl();
        if (currentUrl != null && baseUrl != null && currentUrl.startsWith(baseUrl)) {
            currentUrl = currentUrl.substring(baseUrl.length());
        }
        return currentUrl;
    }

    private String buildUrl(String url) {
        String currentUrl = this.getDriver().getCurrentUrl();
        String baseUrl = UrlUtils.sanitizeBaseUrl(this.getBaseUrl(), currentUrl);
        return UrlUtils.concat(baseUrl, url);
    }

    @Override
    public String pageSource() {
        return this.getDriver().getPageSource();
    }

    @Override
    public <P extends FluentPage> P goTo(P page) {
        Preconditions.checkArgument(page, "It is required to specify an instance of FluentPage for navigation.");
        page.go();
        return page;
    }

    @Override
    public void goTo(String url) {
        Preconditions.checkArgument(url, "It is required to specify a URL to navigate to.");
        this.getDriver().get(this.buildUrl(url));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void goToInNewTab(String url) {
        String newTab;
        Preconditions.checkArgument(url, "It is required to specify a URL to navigate to (in a new tab).");
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            Set initialTabs = this.getDriver().getWindowHandles();
            this.executeScript("window.open('" + this.buildUrl(url) + "', '_blank');", new Object[0]);
            Set tabs = this.getDriver().getWindowHandles();
            tabs.removeAll(initialTabs);
            newTab = (String)tabs.iterator().next();
        }
        this.getDriver().switchTo().window(newTab);
    }

    @Override
    public Capabilities capabilities() {
        return this.capabilitiesProvider.getCapabilities(this.getDriver());
    }

    @Override
    public FluentJavascript executeScript(String script, Object ... args) {
        return new FluentJavascript((JavascriptExecutor)this.getDriver(), false, script, args);
    }

    @Override
    public FluentJavascript executeAsyncScript(String script, Object ... args) {
        return new FluentJavascript((JavascriptExecutor)this.getDriver(), true, script, args);
    }

    @Override
    public void switchTo(FluentList<? extends FluentWebElement> elements) {
        this.switchTo(elements.first());
    }

    @Override
    public void switchTo(FluentWebElement element) {
        if (null == element || !"iframe".equals(element.tagName())) {
            this.getDriver().switchTo().defaultContent();
        } else {
            WebElement target = element.getElement();
            while (target instanceof WrapsElement && target != ElementUtils.getWrappedElement(target)) {
                target = ElementUtils.getWrappedElement(target);
            }
            this.getDriver().switchTo().frame(target);
        }
    }

    @Override
    public void switchTo() {
        this.switchTo((FluentWebElement)null);
    }

    @Override
    public void switchToDefault() {
        this.switchTo((FluentWebElement)null);
    }

    @Override
    public Alert alert() {
        return new AlertImpl(this.getDriver());
    }

    public void quit() {
        if (this.getDriver() != null) {
            this.getDriver().quit();
        }
        this.releaseFluent();
    }

    public void releaseFluent() {
        this.fluentInjector.release();
        if (this.componentsEventsRegistry != null) {
            this.componentsEventsRegistry.close();
        }
    }

    @Override
    protected ComponentsManager getComponentsManager() {
        return this.componentsManager;
    }

    @Override
    protected Search getSearch() {
        return this.search;
    }

    @Override
    public ContainerContext inject(Object container) {
        return this.fluentInjector.inject(container);
    }

    @Override
    public <T> T newInstance(Class<T> cls) {
        return this.fluentInjector.newInstance(cls);
    }

    @Override
    public ContainerContext injectComponent(Object componentContainer, Object parentContainer, SearchContext searchContext) {
        return this.fluentInjector.injectComponent(componentContainer, parentContainer, searchContext);
    }

    @Override
    public CssSupport css() {
        return this.cssControl.css();
    }

    @Override
    public PerformanceTiming performanceTiming() {
        return this.performanceTiming;
    }
}

