/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.core.events;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.function.Function;
import org.fluentlenium.core.events.AlertListener;
import org.fluentlenium.core.events.EventAnnotationsException;
import org.fluentlenium.core.events.ListenerContext;
import org.fluentlenium.core.events.ListenerPriority;
import org.fluentlenium.utils.ReflectionUtils;
import org.openqa.selenium.WebDriver;

class AnnotationAlertListener
implements AlertListener,
ListenerPriority {
    private final Method method;
    private final Object container;
    private final String annotationName;
    private final int priority;

    AnnotationAlertListener(ListenerContext listenerContext) {
        this.method = listenerContext.getMethod();
        this.container = listenerContext.getContainer();
        this.annotationName = listenerContext.getAnnotationName();
        this.priority = listenerContext.getPriority();
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    protected Function<Class<?>, Object> getArgsFunction(WebDriver driver) {
        return input -> {
            if (input.isAssignableFrom(WebDriver.class)) {
                return driver;
            }
            return null;
        };
    }

    @Override
    public void on(WebDriver driver) {
        Class<?>[] parameterTypes = this.method.getParameterTypes();
        Object[] args = ReflectionUtils.toArgs(this.getArgsFunction(driver), parameterTypes);
        try {
            ReflectionUtils.invoke(this.method, this.container, args);
        }
        catch (IllegalAccessException e) {
            throw new EventAnnotationsException("An error has occured in " + this.annotationName + " " + this.method, e);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof RuntimeException) {
                throw (RuntimeException)e.getTargetException();
            }
            if (e.getTargetException() instanceof Error) {
                throw (Error)e.getTargetException();
            }
            throw new EventAnnotationsException("An error has occured in " + this.annotationName + " " + this.method, e);
        }
    }
}

