/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.core.filter;

import java.util.regex.Pattern;
import org.fluentlenium.core.filter.matcher.AbstractMatcher;
import org.fluentlenium.core.filter.matcher.ContainsMatcher;
import org.fluentlenium.core.filter.matcher.EndsWithMatcher;
import org.fluentlenium.core.filter.matcher.EqualMatcher;
import org.fluentlenium.core.filter.matcher.NotContainsMatcher;
import org.fluentlenium.core.filter.matcher.NotEndsWithMatcher;
import org.fluentlenium.core.filter.matcher.NotStartsWithMatcher;
import org.fluentlenium.core.filter.matcher.StartsWithMatcher;

public final class MatcherConstructor {
    private MatcherConstructor() {
    }

    public static AbstractMatcher contains(String matcher) {
        return new ContainsMatcher(matcher);
    }

    public static AbstractMatcher contains(Pattern pattern) {
        return new ContainsMatcher(pattern);
    }

    public static AbstractMatcher notContains(String matcher) {
        return new NotContainsMatcher(matcher);
    }

    public static AbstractMatcher notContains(Pattern pattern) {
        return new NotContainsMatcher(pattern);
    }

    public static AbstractMatcher equal(String matcher) {
        return new EqualMatcher(matcher);
    }

    public static Pattern regex(String pattern) {
        return Pattern.compile(pattern);
    }

    public static AbstractMatcher startsWith(String matcher) {
        return new StartsWithMatcher(matcher);
    }

    public static AbstractMatcher startsWith(Pattern pattern) {
        return new StartsWithMatcher(pattern);
    }

    public static AbstractMatcher endsWith(String matcher) {
        return new EndsWithMatcher(matcher);
    }

    public static AbstractMatcher endsWith(Pattern pattern) {
        return new EndsWithMatcher(pattern);
    }

    public static AbstractMatcher notStartsWith(String matcher) {
        return new NotStartsWithMatcher(matcher);
    }

    public static AbstractMatcher notStartsWith(Pattern pattern) {
        return new NotStartsWithMatcher(pattern);
    }

    public static AbstractMatcher notEndsWith(String matcher) {
        return new NotEndsWithMatcher(matcher);
    }

    public static AbstractMatcher notEndsWith(Pattern pattern) {
        return new NotEndsWithMatcher(pattern);
    }
}

