/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.service.classloading.internal;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.hibernate.internal.util.ClassLoaderHelper;
import org.hibernate.service.classloading.spi.ClassLoaderService;
import org.hibernate.service.classloading.spi.ClassLoadingException;
import org.jboss.logging.Logger;

public class ClassLoaderServiceImpl
implements ClassLoaderService {
    private static final Logger log = Logger.getLogger(ClassLoaderServiceImpl.class);
    private AggregatedClassLoader aggregatedClassLoader;
    private final Map<Class, ServiceLoader> serviceLoaders = new HashMap<Class, ServiceLoader>();

    public ClassLoaderServiceImpl() {
        this(ClassLoaderServiceImpl.class.getClassLoader());
    }

    public ClassLoaderServiceImpl(ClassLoader classLoader) {
        this(Collections.singletonList(classLoader));
    }

    public ClassLoaderServiceImpl(List<ClassLoader> providedClassLoaders) {
        ClassLoader sysClassLoader;
        LinkedHashSet<ClassLoader> orderedClassLoaderSet = new LinkedHashSet<ClassLoader>();
        if (providedClassLoaders != null) {
            for (ClassLoader classLoader : providedClassLoaders) {
                if (classLoader == null) continue;
                orderedClassLoaderSet.add(classLoader);
            }
        }
        if (ClassLoaderHelper.overridenClassLoader != null) {
            orderedClassLoaderSet.add(ClassLoaderHelper.overridenClassLoader);
        }
        orderedClassLoaderSet.add(ClassLoaderServiceImpl.class.getClassLoader());
        ClassLoader tccl = ClassLoaderServiceImpl.locateTCCL();
        if (tccl != null) {
            orderedClassLoaderSet.add(tccl);
        }
        if ((sysClassLoader = ClassLoaderServiceImpl.locateSystemClassLoader()) != null) {
            orderedClassLoaderSet.add(sysClassLoader);
        }
        this.aggregatedClassLoader = new AggregatedClassLoader(orderedClassLoaderSet);
    }

    @Deprecated
    public static ClassLoaderServiceImpl fromConfigSettings(Map configVales) {
        ArrayList<ClassLoader> providedClassLoaders = new ArrayList<ClassLoader>();
        Collection classLoaders = (Collection)configVales.get("hibernate.classLoaders");
        if (classLoaders != null) {
            for (ClassLoader classLoader : classLoaders) {
                providedClassLoaders.add(classLoader);
            }
        }
        ClassLoaderServiceImpl.addIfSet(providedClassLoaders, "hibernate.classLoader.application", configVales);
        ClassLoaderServiceImpl.addIfSet(providedClassLoaders, "hibernate.classLoader.resources", configVales);
        ClassLoaderServiceImpl.addIfSet(providedClassLoaders, "hibernate.classLoader.hibernate", configVales);
        ClassLoaderServiceImpl.addIfSet(providedClassLoaders, "hibernate.classLoader.environment", configVales);
        return new ClassLoaderServiceImpl(providedClassLoaders);
    }

    private static void addIfSet(List<ClassLoader> providedClassLoaders, String name, Map configVales) {
        ClassLoader providedClassLoader = (ClassLoader)configVales.get(name);
        if (providedClassLoader != null) {
            providedClassLoaders.add(providedClassLoader);
        }
    }

    private static ClassLoader locateSystemClassLoader() {
        try {
            return ClassLoader.getSystemClassLoader();
        }
        catch (Exception e) {
            return null;
        }
    }

    private static ClassLoader locateTCCL() {
        try {
            return Thread.currentThread().getContextClassLoader();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public <T> Class<T> classForName(String className) {
        try {
            return Class.forName(className, true, this.aggregatedClassLoader);
        }
        catch (Exception e) {
            throw new ClassLoadingException("Unable to load class [" + className + "]", e);
        }
    }

    @Override
    public URL locateResource(String name) {
        try {
            return new URL(name);
        }
        catch (Exception ignore) {
            try {
                return this.aggregatedClassLoader.getResource(name);
            }
            catch (Exception exception) {
                return null;
            }
        }
    }

    @Override
    public InputStream locateResourceStream(String name) {
        try {
            log.tracef("trying via [new URL(\"%s\")]", (Object)name);
            return new URL(name).openStream();
        }
        catch (Exception ignore) {
            String stripped;
            try {
                log.tracef("trying via [ClassLoader.getResourceAsStream(\"%s\")]", (Object)name);
                InputStream stream = this.aggregatedClassLoader.getResourceAsStream(name);
                if (stream != null) {
                    return stream;
                }
            }
            catch (Exception ignore2) {
                // empty catch block
            }
            String string = stripped = name.startsWith("/") ? name.substring(1) : null;
            if (stripped != null) {
                try {
                    log.tracef("trying via [new URL(\"%s\")]", (Object)stripped);
                    return new URL(stripped).openStream();
                }
                catch (Exception ignore3) {
                    try {
                        log.tracef("trying via [ClassLoader.getResourceAsStream(\"%s\")]", (Object)stripped);
                        InputStream stream = this.aggregatedClassLoader.getResourceAsStream(stripped);
                        if (stream != null) {
                            return stream;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            return null;
        }
    }

    @Override
    public List<URL> locateResources(String name) {
        ArrayList<URL> urls = new ArrayList<URL>();
        try {
            Enumeration<URL> urlEnumeration = this.aggregatedClassLoader.getResources(name);
            if (urlEnumeration != null && urlEnumeration.hasMoreElements()) {
                while (urlEnumeration.hasMoreElements()) {
                    urls.add(urlEnumeration.nextElement());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return urls;
    }

    @Override
    public <S> LinkedHashSet<S> loadJavaServices(Class<S> serviceContract) {
        ServiceLoader serviceLoader;
        if (this.serviceLoaders.containsKey(serviceContract)) {
            serviceLoader = this.serviceLoaders.get(serviceContract);
        } else {
            serviceLoader = ServiceLoader.load(serviceContract, this.aggregatedClassLoader);
            this.serviceLoaders.put(serviceContract, serviceLoader);
        }
        LinkedHashSet services = new LinkedHashSet();
        for (Object service : serviceLoader) {
            services.add(service);
        }
        return services;
    }

    @Override
    public void stop() {
        for (ServiceLoader serviceLoader : this.serviceLoaders.values()) {
            serviceLoader.reload();
        }
        this.serviceLoaders.clear();
        if (this.aggregatedClassLoader != null) {
            this.aggregatedClassLoader.destroy();
            this.aggregatedClassLoader = null;
        }
    }

    private static class AggregatedClassLoader
    extends ClassLoader {
        private ClassLoader[] individualClassLoaders;

        private AggregatedClassLoader(LinkedHashSet<ClassLoader> orderedClassLoaderSet) {
            super(null);
            this.individualClassLoaders = orderedClassLoaderSet.toArray(new ClassLoader[orderedClassLoaderSet.size()]);
        }

        @Override
        public Enumeration<URL> getResources(String name) throws IOException {
            final LinkedHashSet<URL> resourceUrls = new LinkedHashSet<URL>();
            for (ClassLoader classLoader : this.individualClassLoaders) {
                Enumeration<URL> urls = classLoader.getResources(name);
                while (urls.hasMoreElements()) {
                    resourceUrls.add(urls.nextElement());
                }
            }
            return new Enumeration<URL>(){
                final Iterator<URL> resourceUrlIterator;
                {
                    this.resourceUrlIterator = resourceUrls.iterator();
                }

                @Override
                public boolean hasMoreElements() {
                    return this.resourceUrlIterator.hasNext();
                }

                @Override
                public URL nextElement() {
                    return this.resourceUrlIterator.next();
                }
            };
        }

        @Override
        protected URL findResource(String name) {
            for (ClassLoader classLoader : this.individualClassLoaders) {
                URL resource = classLoader.getResource(name);
                if (resource == null) continue;
                return resource;
            }
            return super.findResource(name);
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            for (ClassLoader classLoader : this.individualClassLoaders) {
                try {
                    return classLoader.loadClass(name);
                }
                catch (Exception ignore) {
                }
            }
            throw new ClassNotFoundException("Could not load requested class : " + name);
        }

        public void destroy() {
            this.individualClassLoaders = null;
        }
    }
}

