/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode.internal.javassist;

import java.io.Serializable;
import org.hibernate.PropertyAccessException;
import org.hibernate.bytecode.internal.javassist.BulkAccessor;
import org.hibernate.bytecode.internal.javassist.BulkAccessorException;
import org.hibernate.bytecode.spi.ReflectionOptimizer;

public class AccessOptimizerAdapter
implements ReflectionOptimizer.AccessOptimizer,
Serializable {
    private static final String PROPERTY_GET_EXCEPTION = String.format("exception getting property value with Javassist (set %s to false for more info)", "hibernate.bytecode.use_reflection_optimizer");
    private static final String PROPERTY_SET_EXCEPTION = String.format("exception setting property value with Javassist (set %s to false for more info)", "hibernate.bytecode.use_reflection_optimizer");
    private final BulkAccessor bulkAccessor;
    private final Class mappedClass;

    public AccessOptimizerAdapter(BulkAccessor bulkAccessor, Class mappedClass) {
        this.bulkAccessor = bulkAccessor;
        this.mappedClass = mappedClass;
    }

    @Override
    public String[] getPropertyNames() {
        return this.bulkAccessor.getGetters();
    }

    @Override
    public Object[] getPropertyValues(Object object) {
        try {
            return this.bulkAccessor.getPropertyValues(object);
        }
        catch (Throwable t) {
            throw new PropertyAccessException(t, PROPERTY_GET_EXCEPTION, false, this.mappedClass, AccessOptimizerAdapter.getterName(t, this.bulkAccessor));
        }
    }

    @Override
    public void setPropertyValues(Object object, Object[] values) {
        try {
            this.bulkAccessor.setPropertyValues(object, values);
        }
        catch (Throwable t) {
            throw new PropertyAccessException(t, PROPERTY_SET_EXCEPTION, true, this.mappedClass, AccessOptimizerAdapter.setterName(t, this.bulkAccessor));
        }
    }

    private static String setterName(Throwable t, BulkAccessor accessor) {
        if (t instanceof BulkAccessorException) {
            return accessor.getSetters()[((BulkAccessorException)((Object)t)).getIndex()];
        }
        return "?";
    }

    private static String getterName(Throwable t, BulkAccessor accessor) {
        if (t instanceof BulkAccessorException) {
            return accessor.getGetters()[((BulkAccessorException)((Object)t)).getIndex()];
        }
        return "?";
    }
}

