/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.configuration.internal.metadata.reader;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.persistence.ElementCollection;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.MapKey;
import javax.persistence.OneToMany;
import javax.persistence.Version;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.annotations.common.reflection.ClassLoadingException;
import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.envers.AuditJoinTable;
import org.hibernate.envers.AuditMappedBy;
import org.hibernate.envers.AuditOverride;
import org.hibernate.envers.AuditOverrides;
import org.hibernate.envers.Audited;
import org.hibernate.envers.ModificationStore;
import org.hibernate.envers.NotAudited;
import org.hibernate.envers.RelationTargetAuditMode;
import org.hibernate.envers.configuration.internal.GlobalConfiguration;
import org.hibernate.envers.configuration.internal.metadata.MetadataTools;
import org.hibernate.envers.configuration.internal.metadata.reader.AuditedPropertiesHolder;
import org.hibernate.envers.configuration.internal.metadata.reader.ComponentAuditedPropertiesReader;
import org.hibernate.envers.configuration.internal.metadata.reader.ComponentAuditingData;
import org.hibernate.envers.configuration.internal.metadata.reader.DynamicProperty;
import org.hibernate.envers.configuration.internal.metadata.reader.PersistentPropertiesSource;
import org.hibernate.envers.configuration.internal.metadata.reader.PropertyAuditingData;
import org.hibernate.envers.internal.EnversMessageLogger;
import org.hibernate.envers.internal.tools.MappingTools;
import org.hibernate.envers.internal.tools.ReflectionTools;
import org.hibernate.envers.internal.tools.StringTools;
import org.hibernate.envers.internal.tools.Tools;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Value;
import org.jboss.logging.Logger;

public class AuditedPropertiesReader {
    private static final EnversMessageLogger LOG = (EnversMessageLogger)Logger.getMessageLogger(EnversMessageLogger.class, (String)AuditedPropertiesReader.class.getName());
    protected final ModificationStore defaultStore;
    private final PersistentPropertiesSource persistentPropertiesSource;
    private final AuditedPropertiesHolder auditedPropertiesHolder;
    private final GlobalConfiguration globalCfg;
    private final ReflectionManager reflectionManager;
    private final String propertyNamePrefix;
    private final Map<String, String> propertyAccessedPersistentProperties;
    private final Set<String> fieldAccessedPersistentProperties;
    private final Map<String, String> propertiesGroupMapping;
    private final Set<XProperty> overriddenAuditedProperties;
    private final Set<XProperty> overriddenNotAuditedProperties;
    private final Map<XProperty, AuditJoinTable> overriddenAuditedPropertiesJoinTables;
    private final Set<XClass> overriddenAuditedClasses;
    private final Set<XClass> overriddenNotAuditedClasses;
    private static final Audited DEFAULT_AUDITED = new Audited(){

        @Override
        public ModificationStore modStore() {
            return ModificationStore.FULL;
        }

        @Override
        public RelationTargetAuditMode targetAuditMode() {
            return RelationTargetAuditMode.AUDITED;
        }

        @Override
        public Class[] auditParents() {
            return new Class[0];
        }

        @Override
        public boolean withModifiedFlag() {
            return false;
        }

        @Override
        public String modifiedColumnName() {
            return "";
        }

        @Override
        public Class<? extends Annotation> annotationType() {
            return this.getClass();
        }
    };
    private static final AuditJoinTable DEFAULT_AUDIT_JOIN_TABLE = new AuditJoinTable(){

        @Override
        public String name() {
            return "";
        }

        @Override
        public String schema() {
            return "";
        }

        @Override
        public String catalog() {
            return "";
        }

        @Override
        public JoinColumn[] inverseJoinColumns() {
            return new JoinColumn[0];
        }

        @Override
        public Class<? extends Annotation> annotationType() {
            return this.getClass();
        }
    };

    public AuditedPropertiesReader(ModificationStore defaultStore, PersistentPropertiesSource persistentPropertiesSource, AuditedPropertiesHolder auditedPropertiesHolder, GlobalConfiguration globalCfg, ReflectionManager reflectionManager, String propertyNamePrefix) {
        this.defaultStore = defaultStore;
        this.persistentPropertiesSource = persistentPropertiesSource;
        this.auditedPropertiesHolder = auditedPropertiesHolder;
        this.globalCfg = globalCfg;
        this.reflectionManager = reflectionManager;
        this.propertyNamePrefix = propertyNamePrefix;
        this.propertyAccessedPersistentProperties = Tools.newHashMap();
        this.fieldAccessedPersistentProperties = Tools.newHashSet();
        this.propertiesGroupMapping = Tools.newHashMap();
        this.overriddenAuditedProperties = Tools.newHashSet();
        this.overriddenNotAuditedProperties = Tools.newHashSet();
        this.overriddenAuditedPropertiesJoinTables = Tools.newHashMap();
        this.overriddenAuditedClasses = Tools.newHashSet();
        this.overriddenNotAuditedClasses = Tools.newHashSet();
    }

    public void read() {
        this.readPersistentPropertiesAccess();
        if (this.persistentPropertiesSource instanceof DynamicComponentSource) {
            this.addPropertiesFromDynamicComponent((DynamicComponentSource)this.persistentPropertiesSource);
        } else {
            XClass clazz = this.persistentPropertiesSource.getXClass();
            this.readAuditOverrides(clazz);
            this.addPropertiesFromClass(clazz);
        }
    }

    private void readAuditOverrides(XClass clazz) {
        Audited allClassAudited = (Audited)clazz.getAnnotation(Audited.class);
        if (allClassAudited != null && allClassAudited.auditParents().length > 0) {
            for (Class c : allClassAudited.auditParents()) {
                XClass parentClass = this.reflectionManager.toXClass(c);
                this.checkSuperclass(clazz, parentClass);
                if (this.overriddenNotAuditedClasses.contains(parentClass)) continue;
                this.overriddenAuditedClasses.add(parentClass);
            }
        }
        List<AuditOverride> auditOverrides = this.computeAuditOverrides(clazz);
        for (AuditOverride auditOverride : auditOverrides) {
            if (auditOverride.forClass() == Void.TYPE) continue;
            XClass overrideClass = this.reflectionManager.toXClass(auditOverride.forClass());
            this.checkSuperclass(clazz, overrideClass);
            String propertyName = auditOverride.name();
            if (!StringTools.isEmpty(propertyName)) {
                XProperty property = this.getProperty(overrideClass, propertyName);
                if (auditOverride.isAudited()) {
                    if (this.overriddenNotAuditedProperties.contains(property)) continue;
                    this.overriddenAuditedProperties.add(property);
                    this.overriddenAuditedPropertiesJoinTables.put(property, auditOverride.auditJoinTable());
                    continue;
                }
                if (this.overriddenAuditedProperties.contains(property)) continue;
                this.overriddenNotAuditedProperties.add(property);
                continue;
            }
            if (auditOverride.isAudited()) {
                if (this.overriddenNotAuditedClasses.contains(overrideClass)) continue;
                this.overriddenAuditedClasses.add(overrideClass);
                continue;
            }
            if (this.overriddenAuditedClasses.contains(overrideClass)) continue;
            this.overriddenNotAuditedClasses.add(overrideClass);
        }
        XClass superclass = clazz.getSuperclass();
        if (!clazz.isInterface() && !Object.class.getName().equals(superclass.getName())) {
            this.readAuditOverrides(superclass);
        }
    }

    private List<AuditOverride> computeAuditOverrides(XClass clazz) {
        AuditOverrides auditOverrides = (AuditOverrides)clazz.getAnnotation(AuditOverrides.class);
        AuditOverride auditOverride = (AuditOverride)clazz.getAnnotation(AuditOverride.class);
        if (auditOverrides == null && auditOverride != null) {
            return Arrays.asList(auditOverride);
        }
        if (auditOverrides != null && auditOverride == null) {
            return Arrays.asList(auditOverrides.value());
        }
        if (auditOverrides != null && auditOverride != null) {
            throw new MappingException("@AuditOverrides annotation should encapsulate all @AuditOverride declarations. Please revise Envers annotations applied to class " + clazz.getName() + ".");
        }
        return Collections.emptyList();
    }

    private void checkSuperclass(XClass child, XClass parent) {
        if (!parent.isAssignableFrom(child)) {
            throw new MappingException("Class " + parent.getName() + " is not assignable from " + child.getName() + ". Please revise Envers annotations applied to " + child.getName() + " type.");
        }
    }

    private XProperty getProperty(XClass clazz, String propertyName) {
        XProperty property = ReflectionTools.getProperty(clazz, propertyName);
        if (property == null) {
            throw new MappingException("Property '" + propertyName + "' not found in class " + clazz.getName() + ". Please revise Envers annotations applied to class " + this.persistentPropertiesSource.getXClass() + ".");
        }
        return property;
    }

    private void readPersistentPropertiesAccess() {
        Iterator<Property> propertyIter = this.persistentPropertiesSource.getPropertyIterator();
        while (propertyIter.hasNext()) {
            Property property = propertyIter.next();
            this.addPersistentProperty(property);
            if (!"embedded".equals(property.getPropertyAccessorName()) || "_identifierMapper".equals(property.getName())) continue;
            this.createPropertiesGroupMapping(property);
        }
    }

    private void addPersistentProperty(Property property) {
        if ("field".equals(property.getPropertyAccessorName())) {
            this.fieldAccessedPersistentProperties.add(property.getName());
        } else {
            this.propertyAccessedPersistentProperties.put(property.getName(), property.getPropertyAccessorName());
        }
    }

    private void createPropertiesGroupMapping(Property property) {
        Component component = (Component)property.getValue();
        Iterator componentProperties = component.getPropertyIterator();
        while (componentProperties.hasNext()) {
            Property componentProperty = (Property)componentProperties.next();
            this.propertiesGroupMapping.put(componentProperty.getName(), property.getName());
        }
    }

    private Audited computeAuditConfiguration(XClass clazz) {
        Audited allClassAudited = (Audited)clazz.getAnnotation(Audited.class);
        if (allClassAudited == null && this.overriddenAuditedClasses.contains(clazz)) {
            allClassAudited = (Audited)this.persistentPropertiesSource.getXClass().getAnnotation(Audited.class);
            if (allClassAudited == null) {
                allClassAudited = DEFAULT_AUDITED;
            }
        } else if (allClassAudited != null && this.overriddenNotAuditedClasses.contains(clazz)) {
            return null;
        }
        return allClassAudited;
    }

    private void addPropertiesFromDynamicComponent(DynamicComponentSource dynamicComponentSource) {
        Audited audited = this.computeAuditConfiguration(dynamicComponentSource.getXClass());
        if (!this.fieldAccessedPersistentProperties.isEmpty()) {
            throw new MappingException("Audited dynamic component cannot have properties with access=\"field\" for properties: " + this.fieldAccessedPersistentProperties + ". \n Change properties access=\"property\", to make it work)");
        }
        for (Map.Entry<String, String> entry : this.propertyAccessedPersistentProperties.entrySet()) {
            String property = entry.getKey();
            String accessType = entry.getValue();
            if (this.auditedPropertiesHolder.contains(property)) continue;
            Value propertyValue = this.persistentPropertiesSource.getProperty(property).getValue();
            if (propertyValue instanceof Component) {
                this.addFromComponentProperty(new DynamicProperty(dynamicComponentSource, property), accessType, (Component)propertyValue, audited);
                continue;
            }
            this.addFromNotComponentProperty(new DynamicProperty(dynamicComponentSource, property), accessType, audited);
        }
    }

    private void addPropertiesFromClass(XClass clazz) {
        Audited allClassAudited = this.computeAuditConfiguration(clazz);
        this.addFromProperties(clazz.getDeclaredProperties("field"), it -> "field", this.fieldAccessedPersistentProperties, allClassAudited);
        this.addFromProperties(clazz.getDeclaredProperties("property"), this.propertyAccessedPersistentProperties::get, this.propertyAccessedPersistentProperties.keySet(), allClassAudited);
        if (allClassAudited != null || !this.auditedPropertiesHolder.isEmpty()) {
            XClass superclazz = clazz.getSuperclass();
            if (!clazz.isInterface() && !"java.lang.Object".equals(superclazz.getName())) {
                this.addPropertiesFromClass(superclazz);
            }
        }
    }

    private void addFromProperties(Iterable<XProperty> properties, Function<String, String> accessTypeProvider, Set<String> persistentProperties, Audited allClassAudited) {
        for (XProperty property : properties) {
            String embeddedName;
            String accessType = accessTypeProvider.apply(property.getName());
            if (persistentProperties.contains(property.getName()) && !this.auditedPropertiesHolder.contains(property.getName())) {
                Value propertyValue = this.persistentPropertiesSource.getProperty(property.getName()).getValue();
                if (propertyValue instanceof Component) {
                    this.addFromComponentProperty(property, accessType, (Component)propertyValue, allClassAudited);
                    continue;
                }
                this.addFromNotComponentProperty(property, accessType, allClassAudited);
                continue;
            }
            if (!this.propertiesGroupMapping.containsKey(property.getName()) || this.auditedPropertiesHolder.contains(embeddedName = this.propertiesGroupMapping.get(property.getName()))) continue;
            Value propertyValue = this.persistentPropertiesSource.getProperty(embeddedName).getValue();
            this.addFromPropertiesGroup(embeddedName, property, accessType, (Component)propertyValue, allClassAudited);
        }
    }

    private void addFromPropertiesGroup(String embeddedName, XProperty property, String accessType, Component propertyValue, Audited allClassAudited) {
        ComponentAuditingData componentData = new ComponentAuditingData();
        boolean isAudited = this.fillPropertyData(property, componentData, accessType, allClassAudited);
        if (isAudited) {
            componentData.setName(embeddedName);
            componentData.setBeanName(null);
            ComponentPropertiesSource componentPropertiesSource = new ComponentPropertiesSource(this.reflectionManager, propertyValue);
            AuditedPropertiesReader audPropReader = new AuditedPropertiesReader(ModificationStore.FULL, componentPropertiesSource, componentData, this.globalCfg, this.reflectionManager, this.propertyNamePrefix + MappingTools.createComponentPrefix(embeddedName));
            audPropReader.read();
            this.auditedPropertiesHolder.addPropertyAuditingData(embeddedName, componentData);
        }
    }

    private void addFromComponentProperty(XProperty property, String accessType, Component propertyValue, Audited allClassAudited) {
        ComponentAuditingData componentData = new ComponentAuditingData();
        boolean isAudited = this.fillPropertyData(property, componentData, accessType, allClassAudited);
        ComponentPropertiesSource componentPropertiesSource = propertyValue.isDynamic() ? new DynamicComponentSource(this.reflectionManager, propertyValue, property) : new ComponentPropertiesSource(this.reflectionManager, propertyValue);
        ComponentAuditedPropertiesReader audPropReader = new ComponentAuditedPropertiesReader(ModificationStore.FULL, componentPropertiesSource, componentData, this.globalCfg, this.reflectionManager, this.propertyNamePrefix + MappingTools.createComponentPrefix(property.getName()));
        audPropReader.read();
        if (isAudited) {
            this.auditedPropertiesHolder.addPropertyAuditingData(property.getName(), componentData);
        }
    }

    private void addFromNotComponentProperty(XProperty property, String accessType, Audited allClassAudited) {
        PropertyAuditingData propertyData = new PropertyAuditingData();
        boolean isAudited = this.fillPropertyData(property, propertyData, accessType, allClassAudited);
        if (isAudited) {
            this.auditedPropertiesHolder.addPropertyAuditingData(property.getName(), propertyData);
        }
    }

    private boolean fillPropertyData(XProperty property, PropertyAuditingData propertyData, String accessType, Audited allClassAudited) {
        Version jpaVer;
        NotAudited unVer = (NotAudited)property.getAnnotation(NotAudited.class);
        if (unVer != null && !this.overriddenAuditedProperties.contains(property) || this.overriddenNotAuditedProperties.contains(property)) {
            return false;
        }
        if (this.globalCfg.isDoNotAuditOptimisticLockingField() && (jpaVer = (Version)property.getAnnotation(Version.class)) != null) {
            return false;
        }
        String propertyName = this.propertyNamePrefix + property.getName();
        if (!this.checkAudited(property, propertyData, propertyName, allClassAudited, this.globalCfg.getModifiedFlagSuffix())) {
            return false;
        }
        this.validateLobMappingSupport(property);
        propertyData.setName(propertyName);
        propertyData.setBeanName(property.getName());
        propertyData.setAccessType(accessType);
        this.addPropertyJoinTables(property, propertyData);
        this.addPropertyAuditingOverrides(property, propertyData);
        if (!this.processPropertyAuditingOverrides(property, propertyData)) {
            return false;
        }
        this.addPropertyMapKey(property, propertyData);
        this.setPropertyAuditMappedBy(property, propertyData);
        this.setPropertyRelationMappedBy(property, propertyData);
        return true;
    }

    private void validateLobMappingSupport(XProperty property) {
        try {
            if (property.isAnnotationPresent(ElementCollection.class) && property.isAnnotationPresent(Lob.class) && !property.getCollectionClass().isAssignableFrom(Map.class)) {
                throw new MappingException("@ElementCollection combined with @Lob is only supported for Map collection types.");
            }
        }
        catch (MappingException e) {
            throw new HibernateException(String.format("Invalid mapping in [%s] for property [%s]", property.getDeclaringClass().getName(), property.getName()), (Throwable)e);
        }
    }

    protected boolean checkAudited(XProperty property, PropertyAuditingData propertyData, String propertyName, Audited allClassAudited, String modifiedFlagSuffix) {
        Audited aud;
        Audited audited = aud = property.isAnnotationPresent(Audited.class) ? (Audited)property.getAnnotation(Audited.class) : allClassAudited;
        if (aud == null && this.overriddenAuditedProperties.contains(property) && !this.overriddenNotAuditedProperties.contains(property)) {
            aud = DEFAULT_AUDITED;
        }
        if (aud != null) {
            propertyData.setStore(aud.modStore());
            propertyData.setRelationTargetAuditMode(aud.targetAuditMode());
            propertyData.setUsingModifiedFlag(this.checkUsingModifiedFlag(aud));
            if (aud.modifiedColumnName() != null && !"".equals(aud.modifiedColumnName())) {
                propertyData.setModifiedFlagName(aud.modifiedColumnName());
            } else {
                propertyData.setModifiedFlagName(MetadataTools.getModifiedFlagPropertyName(propertyName, modifiedFlagSuffix));
            }
            return true;
        }
        return false;
    }

    protected boolean checkUsingModifiedFlag(Audited aud) {
        if (this.globalCfg.hasSettingForUsingModifiedFlag()) {
            return this.globalCfg.isGlobalWithModifiedFlag() || aud.withModifiedFlag();
        }
        return aud.withModifiedFlag();
    }

    private void setPropertyRelationMappedBy(XProperty property, PropertyAuditingData propertyData) {
        OneToMany oneToMany = (OneToMany)property.getAnnotation(OneToMany.class);
        if (oneToMany != null && !"".equals(oneToMany.mappedBy())) {
            propertyData.setRelationMappedBy(oneToMany.mappedBy());
        }
    }

    private void setPropertyAuditMappedBy(XProperty property, PropertyAuditingData propertyData) {
        AuditMappedBy auditMappedBy = (AuditMappedBy)property.getAnnotation(AuditMappedBy.class);
        if (auditMappedBy != null) {
            propertyData.setAuditMappedBy(auditMappedBy.mappedBy());
            if (!"".equals(auditMappedBy.positionMappedBy())) {
                propertyData.setPositionMappedBy(auditMappedBy.positionMappedBy());
            }
        }
    }

    private void addPropertyMapKey(XProperty property, PropertyAuditingData propertyData) {
        MapKey mapKey = (MapKey)property.getAnnotation(MapKey.class);
        if (mapKey != null) {
            propertyData.setMapKey(mapKey.name());
        }
    }

    private void addPropertyJoinTables(XProperty property, PropertyAuditingData propertyData) {
        AuditJoinTable overrideJoinTable = this.overriddenAuditedPropertiesJoinTables.get(property);
        if (overrideJoinTable != null) {
            propertyData.setJoinTable(overrideJoinTable);
        } else {
            AuditJoinTable propertyJoinTable = (AuditJoinTable)property.getAnnotation(AuditJoinTable.class);
            if (propertyJoinTable != null) {
                propertyData.setJoinTable(propertyJoinTable);
            } else {
                propertyData.setJoinTable(DEFAULT_AUDIT_JOIN_TABLE);
            }
        }
    }

    private void addPropertyAuditingOverrides(XProperty property, PropertyAuditingData propertyData) {
        AuditOverrides annotationOverrides;
        AuditOverride annotationOverride = (AuditOverride)property.getAnnotation(AuditOverride.class);
        if (annotationOverride != null) {
            propertyData.addAuditingOverride(annotationOverride);
        }
        if ((annotationOverrides = (AuditOverrides)property.getAnnotation(AuditOverrides.class)) != null) {
            propertyData.addAuditingOverrides(annotationOverrides);
        }
    }

    private boolean processPropertyAuditingOverrides(XProperty property, PropertyAuditingData propertyData) {
        if (this.auditedPropertiesHolder instanceof ComponentAuditingData) {
            List<AuditOverride> overrides = ((ComponentAuditingData)this.auditedPropertiesHolder).getAuditingOverrides();
            for (AuditOverride override : overrides) {
                if (!property.getName().equals(override.name())) continue;
                if (!override.isAudited()) {
                    return false;
                }
                if (override.auditJoinTable() == null) continue;
                propertyData.setJoinTable(override.auditJoinTable());
            }
        }
        return true;
    }

    public static class DynamicComponentSource
    extends ComponentPropertiesSource {
        private XProperty baseProperty;

        public DynamicComponentSource(ReflectionManager reflectionManager, Component component, XProperty baseProperty) {
            super(reflectionManager.toXClass(Map.class), component);
            this.baseProperty = baseProperty;
        }
    }

    public static class ComponentPropertiesSource
    implements PersistentPropertiesSource {
        private final XClass xclass;
        private final Component component;

        protected ComponentPropertiesSource(XClass xClazz, Component component) {
            this.xclass = xClazz;
            this.component = component;
        }

        public ComponentPropertiesSource(ReflectionManager reflectionManager, Component component) {
            try {
                this.xclass = reflectionManager.classForName(component.getComponentClassName());
            }
            catch (ClassLoadingException e) {
                throw new MappingException((Throwable)e);
            }
            this.component = component;
        }

        @Override
        public Iterator<Property> getPropertyIterator() {
            return this.component.getPropertyIterator();
        }

        @Override
        public Property getProperty(String propertyName) {
            return this.component.getProperty(propertyName);
        }

        @Override
        public XClass getXClass() {
            return this.xclass;
        }
    }
}

