/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.engine.constraintvalidation;

import java.time.Duration;
import javax.validation.ClockProvider;
import org.hibernate.validator.constraintvalidation.HibernateConstraintValidatorInitializationContext;
import org.hibernate.validator.spi.scripting.ScriptEvaluator;
import org.hibernate.validator.spi.scripting.ScriptEvaluatorFactory;

public class HibernateConstraintValidatorInitializationContextImpl
implements HibernateConstraintValidatorInitializationContext {
    private final ScriptEvaluatorFactory scriptEvaluatorFactory;
    private final ClockProvider clockProvider;
    private final Duration temporalValidationTolerance;
    private final Object constraintValidatorPayload;

    public HibernateConstraintValidatorInitializationContextImpl(ScriptEvaluatorFactory scriptEvaluatorFactory, ClockProvider clockProvider, Duration temporalValidationTolerance, Object constraintValidatorPayload) {
        this.scriptEvaluatorFactory = scriptEvaluatorFactory;
        this.clockProvider = clockProvider;
        this.temporalValidationTolerance = temporalValidationTolerance;
        this.constraintValidatorPayload = constraintValidatorPayload;
    }

    @Override
    public ScriptEvaluator getScriptEvaluatorForLanguage(String languageName) {
        return this.scriptEvaluatorFactory.getScriptEvaluatorByLanguageName(languageName);
    }

    @Override
    public ClockProvider getClockProvider() {
        return this.clockProvider;
    }

    @Override
    public Duration getTemporalValidationTolerance() {
        return this.temporalValidationTolerance;
    }

    @Override
    public <C> C getConstraintValidatorPayload(Class<C> type) {
        if (this.constraintValidatorPayload != null && type.isAssignableFrom(this.constraintValidatorPayload.getClass())) {
            return type.cast(this.constraintValidatorPayload);
        }
        return null;
    }
}

