/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.arjuna.abstractrecords;

import com.arjuna.ats.arjuna.StateManager;
import com.arjuna.ats.arjuna.coordinator.AbstractRecord;
import com.arjuna.ats.arjuna.coordinator.BasicAction;
import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.arjuna.state.OutputObjectState;
import com.arjuna.ats.internal.arjuna.abstractrecords.StateManagerFriend;
import java.io.PrintWriter;

public class RecoveryRecord
extends AbstractRecord {
    protected StateManager objectAddr;
    protected OutputObjectState state;
    private BasicAction actionHandle;

    public RecoveryRecord(OutputObjectState os, StateManager sm) {
        super(sm.get_uid(), sm.type(), 1);
        if (tsLogger.logger.isDebugEnabled()) {
            tsLogger.logger.debug("RecoveryRecord::RecoveryRecord(" + os + ", " + sm.get_uid() + ")");
        }
        this.objectAddr = sm;
        this.state = os;
        this.actionHandle = BasicAction.Current();
    }

    @Override
    public int typeIs() {
        return 101;
    }

    @Override
    public Object value() {
        return this.state;
    }

    @Override
    public void setValue(Object newState) {
        if (newState instanceof OutputObjectState) {
            this.state = (OutputObjectState)newState;
        } else {
            tsLogger.i18NLogger.warn_RecoveryRecord_1();
        }
    }

    @Override
    public int nestedAbort() {
        if (tsLogger.logger.isDebugEnabled()) {
            tsLogger.logger.debug("RecoveryRecord::nestedAbort() for " + this.order());
        }
        this.forgetAction(false);
        if (this.state != null && this.state.notempty()) {
            int result;
            InputObjectState oldState = new InputObjectState(this.state);
            int n = result = this.objectAddr.restore_state(oldState, 0) ? 7 : 8;
            if (result == 8) {
                tsLogger.i18NLogger.warn_RecoveryRecord_2();
            }
            return result;
        }
        return 7;
    }

    @Override
    public int nestedCommit() {
        if (tsLogger.logger.isDebugEnabled()) {
            tsLogger.logger.debug("RecoveryRecord::nestedCommit() for " + this.order());
        }
        return 7;
    }

    @Override
    public int nestedPrepare() {
        if (tsLogger.logger.isDebugEnabled()) {
            tsLogger.logger.debug("RecoveryRecord::nestedPrepare() for " + this.order());
        }
        this.forgetAction(true);
        return 2;
    }

    @Override
    public int topLevelAbort() {
        if (tsLogger.logger.isDebugEnabled()) {
            tsLogger.logger.debug("RecoveryRecord::topLevelAbort() for " + this.order());
        }
        return this.nestedAbort();
    }

    @Override
    public int topLevelCommit() {
        if (tsLogger.logger.isDebugEnabled()) {
            tsLogger.logger.debug("RecoveryRecord::topLevelCommit() for " + this.order());
        }
        this.forgetAction(true);
        return 7;
    }

    @Override
    public int topLevelPrepare() {
        if (tsLogger.logger.isDebugEnabled()) {
            tsLogger.logger.debug("RecoveryRecord::topLevelPrepare() for " + this.order());
        }
        return 2;
    }

    @Override
    public boolean doSave() {
        return false;
    }

    @Override
    public boolean restore_state(InputObjectState os, int ot) {
        return super.restore_state(os, ot);
    }

    @Override
    public boolean save_state(OutputObjectState os, int ot) {
        return super.save_state(os, ot);
    }

    @Override
    public void print(PrintWriter strm) {
        super.print(strm);
        strm.println("RecoveryRecord with state:\n" + this.state);
    }

    @Override
    public String type() {
        return "/StateManager/AbstractRecord/RecoveryRecord";
    }

    @Override
    public void merge(AbstractRecord a) {
    }

    @Override
    public void alter(AbstractRecord a) {
    }

    @Override
    public boolean shouldAdd(AbstractRecord a) {
        return false;
    }

    @Override
    public boolean shouldAlter(AbstractRecord a) {
        return false;
    }

    @Override
    public boolean shouldMerge(AbstractRecord a) {
        return false;
    }

    @Override
    public boolean shouldReplace(AbstractRecord a) {
        return false;
    }

    public RecoveryRecord() {
        if (tsLogger.logger.isDebugEnabled()) {
            tsLogger.logger.debug("RecoveryRecord::RecoveryRecord() - crash recovery constructor");
        }
        this.objectAddr = null;
        this.state = null;
        this.actionHandle = null;
    }

    protected final void forgetAction(boolean commit) {
        if (this.actionHandle != null && this.objectAddr != null) {
            StateManagerFriend.forgetAction(this.objectAddr, this.actionHandle, commit, 101);
            this.actionHandle = null;
        }
    }
}

