/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.arjuna.objectstore;

import com.arjuna.ats.arjuna.common.ObjectStoreEnvironmentBean;
import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.arjuna.objectstore.ObjectStore;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.arjuna.state.OutputObjectState;
import com.arjuna.ats.internal.arjuna.objectstore.VolatileStore;
import java.util.concurrent.ConcurrentHashMap;

public class TwoPhaseVolatileStore
extends ObjectStore {
    private ConcurrentHashMap<Uid, StateInstance> _stateMap = new ConcurrentHashMap();
    private VolatileStore store;

    public TwoPhaseVolatileStore(ObjectStoreEnvironmentBean objectStoreEnvironmentBean) throws ObjectStoreException {
        super(objectStoreEnvironmentBean);
        if (objectStoreEnvironmentBean.isVolatileStoreSupportAllObjUids()) {
            this.store = new VolatileStore(objectStoreEnvironmentBean);
        }
    }

    @Override
    public boolean allObjUids(String s, InputObjectState buff, int m) throws ObjectStoreException {
        if (this.store == null) {
            throw new ObjectStoreException("Operation not supported by this implementation");
        }
        return this.store.allObjUids(s, buff, m);
    }

    @Override
    public boolean allTypes(InputObjectState buff) throws ObjectStoreException {
        if (this.store == null) {
            throw new ObjectStoreException("Operation not supported by this implementation");
        }
        return this.store.allTypes(buff);
    }

    @Override
    public int currentState(Uid u, String tn) throws ObjectStoreException {
        StateInstance inst;
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace("TwoPhaseVolatileStore.currentState(Uid=" + u + ", typeName=" + tn + ")");
        }
        if ((inst = this._stateMap.get(u)) != null) {
            if (inst.original != null) {
                return 1;
            }
            if (inst.shadow != null) {
                return 2;
            }
        }
        return -1;
    }

    @Override
    public String getStoreName() {
        return "TwoPhaseVolatileStore";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean commit_state(Uid u, String tn) throws ObjectStoreException {
        ConcurrentHashMap<Uid, StateInstance> concurrentHashMap = this._stateMap;
        synchronized (concurrentHashMap) {
            StateInstance inst = this._stateMap.get(u);
            if (inst == null) {
                throw new ObjectStoreException("Could not find state instance to commit!");
            }
            StateInstance stateInstance = inst;
            synchronized (stateInstance) {
                if (inst.shadow != null) {
                    inst.original = inst.shadow;
                    inst.shadow = null;
                    return true;
                }
                return false;
            }
        }
    }

    @Override
    public boolean hide_state(Uid u, String tn) throws ObjectStoreException {
        throw new ObjectStoreException("Operation not supported by this implementation");
    }

    @Override
    public boolean reveal_state(Uid u, String tn) throws ObjectStoreException {
        throw new ObjectStoreException("Operation not supported by this implementation");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputObjectState read_committed(Uid u, String tn) throws ObjectStoreException {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace("TwoPhaseVolatileStore.read_committed(Uid=" + u + ", typeName=" + tn + ")");
        }
        ConcurrentHashMap<Uid, StateInstance> concurrentHashMap = this._stateMap;
        synchronized (concurrentHashMap) {
            StateInstance inst = this._stateMap.get(u);
            if (inst == null) {
                return null;
            }
            StateInstance stateInstance = inst;
            synchronized (stateInstance) {
                if (inst.original != null) {
                    return new InputObjectState(inst.original);
                }
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputObjectState read_uncommitted(Uid u, String tn) throws ObjectStoreException {
        ConcurrentHashMap<Uid, StateInstance> concurrentHashMap = this._stateMap;
        synchronized (concurrentHashMap) {
            StateInstance inst = this._stateMap.get(u);
            if (inst == null) {
                return null;
            }
            StateInstance stateInstance = inst;
            synchronized (stateInstance) {
                if (inst.shadow != null) {
                    return new InputObjectState(inst.shadow);
                }
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove_committed(Uid u, String tn) throws ObjectStoreException {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace("TwoPhaseVolatileStore.remove_committed(Uid=" + u + ", typeName=" + tn + ")");
        }
        ConcurrentHashMap<Uid, StateInstance> concurrentHashMap = this._stateMap;
        synchronized (concurrentHashMap) {
            StateInstance inst = this._stateMap.get(u);
            if (inst == null) {
                return false;
            }
            StateInstance stateInstance = inst;
            synchronized (stateInstance) {
                if (inst.original != null) {
                    inst.original = null;
                    return true;
                }
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove_uncommitted(Uid u, String tn) throws ObjectStoreException {
        ConcurrentHashMap<Uid, StateInstance> concurrentHashMap = this._stateMap;
        synchronized (concurrentHashMap) {
            StateInstance inst = this._stateMap.get(u);
            if (inst == null) {
                return false;
            }
            StateInstance stateInstance = inst;
            synchronized (stateInstance) {
                if (inst.shadow != null) {
                    inst.shadow = null;
                    return true;
                }
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean write_committed(Uid u, String tn, OutputObjectState buff) throws ObjectStoreException {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace("TwoPhaseVolatileStore.write_committed(Uid=" + u + ", typeName=" + tn + ")");
        }
        ConcurrentHashMap<Uid, StateInstance> concurrentHashMap = this._stateMap;
        synchronized (concurrentHashMap) {
            StateInstance inst = this._stateMap.get(u);
            if (inst == null) {
                this._stateMap.put(u, new StateInstance(buff, null, tn, u));
            } else {
                StateInstance stateInstance = inst;
                synchronized (stateInstance) {
                    if (inst.original != null) {
                        return false;
                    }
                    inst.original = buff;
                }
            }
            if (this.store != null) {
                this.store.addUidMapping(u, tn);
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean write_uncommitted(Uid u, String tn, OutputObjectState buff) throws ObjectStoreException {
        ConcurrentHashMap<Uid, StateInstance> concurrentHashMap = this._stateMap;
        synchronized (concurrentHashMap) {
            StateInstance inst = this._stateMap.get(u);
            if (inst == null) {
                inst = new StateInstance(null, buff, tn, u);
                this._stateMap.put(u, inst);
            } else {
                if (inst.shadow != null) {
                    return false;
                }
                inst.shadow = buff;
            }
            return true;
        }
    }

    @Override
    protected boolean supressEntry(String name) {
        return false;
    }

    private class StateInstance {
        public OutputObjectState original;
        public OutputObjectState shadow;
        public String typeName;
        public Uid uid;

        public StateInstance(OutputObjectState orig, OutputObjectState sd, String tn, Uid u) {
            this.original = orig;
            this.shadow = sd;
            this.typeName = tn;
            this.uid = u;
        }

        public String toString() {
            return "StateInstance < original " + (this.original == null ? "empty" : "present") + ", shadow " + (this.shadow == null ? "empty" : "present") + ", " + this.typeName + " " + this.uid + " >";
        }
    }
}

