/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.arjuna.objectstore;

import com.arjuna.ats.arjuna.common.ObjectStoreEnvironmentBean;
import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.arjuna.objectstore.ObjectStore;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.arjuna.state.OutputObjectState;
import com.arjuna.ats.internal.arjuna.common.UidHelper;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class VolatileStore
extends ObjectStore {
    private ConcurrentMap<Uid, byte[]> stateMap = new ConcurrentHashMap<Uid, byte[]>();
    private ConcurrentMap<Uid, String> stateTypes;

    public VolatileStore(ObjectStoreEnvironmentBean objectStoreEnvironmentBean) throws ObjectStoreException {
        super(objectStoreEnvironmentBean);
        if (objectStoreEnvironmentBean.isVolatileStoreSupportAllObjUids()) {
            this.stateTypes = new ConcurrentHashMap<Uid, String>();
        }
    }

    @Override
    public boolean allObjUids(String s, InputObjectState buff, int m) throws ObjectStoreException {
        if (this.stateTypes == null) {
            throw new ObjectStoreException("Operation not supported by this implementation");
        }
        OutputObjectState store = new OutputObjectState();
        for (Map.Entry entry : this.stateTypes.entrySet()) {
            if (!((String)entry.getValue()).equals(s)) continue;
            this.packUid(store, (Uid)entry.getKey());
        }
        this.packUid(store, Uid.nullUid());
        buff.setBuffer(store.buffer());
        return true;
    }

    @Override
    public boolean allTypes(InputObjectState buff) throws ObjectStoreException {
        if (this.stateTypes == null) {
            throw new ObjectStoreException("Operation not supported by this implementation");
        }
        HashSet types = new HashSet(this.stateTypes.values());
        OutputObjectState store = new OutputObjectState();
        for (String type : types) {
            this.packString(store, type);
        }
        this.packString(store, "");
        buff.setBuffer(store.buffer());
        return true;
    }

    @Override
    public int currentState(Uid u, String tn) throws ObjectStoreException {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace("VolatileStore.currentState(Uid=" + u + ", typeName=" + tn + ")");
        }
        return this.getState(u);
    }

    @Override
    public String getStoreName() {
        return "VolatileStore";
    }

    @Override
    public boolean commit_state(Uid u, String tn) throws ObjectStoreException {
        throw new ObjectStoreException("Operation not supported by this implementation");
    }

    @Override
    public boolean hide_state(Uid u, String tn) throws ObjectStoreException {
        throw new ObjectStoreException("Operation not supported by this implementation");
    }

    @Override
    public boolean reveal_state(Uid u, String tn) throws ObjectStoreException {
        throw new ObjectStoreException("Operation not supported by this implementation");
    }

    @Override
    public InputObjectState read_committed(Uid u, String tn) throws ObjectStoreException {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace("VolatileStore.read_committed(Uid=" + u + ", typeName=" + tn + ")");
        }
        return this.read(u, tn, 1);
    }

    @Override
    public InputObjectState read_uncommitted(Uid u, String tn) throws ObjectStoreException {
        throw new ObjectStoreException("Operation not supported by this implementation");
    }

    @Override
    public boolean remove_committed(Uid u, String tn) throws ObjectStoreException {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace("VolatileStore.remove_committed(Uid=" + u + ", typeName=" + tn + ")");
        }
        return this.remove(u, tn, 1);
    }

    @Override
    public boolean remove_uncommitted(Uid u, String tn) throws ObjectStoreException {
        throw new ObjectStoreException("Operation not supported by this implementation");
    }

    @Override
    public boolean write_committed(Uid u, String tn, OutputObjectState buff) throws ObjectStoreException {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace("VolatileStore.write_committed(Uid=" + u + ", typeName=" + tn + ")");
        }
        if (this.write(u, tn, buff, 1)) {
            if (this.stateTypes != null) {
                this.addUidMapping(u, tn);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean write_uncommitted(Uid u, String tn, OutputObjectState buff) throws ObjectStoreException {
        throw new ObjectStoreException("Operation not supported by this implementation");
    }

    void addUidMapping(Uid uid, String typeName) {
        this.stateTypes.put(uid, typeName);
    }

    @Override
    protected boolean supressEntry(String name) {
        return false;
    }

    private boolean remove(Uid u, String tn, int state) throws ObjectStoreException {
        Object oldValue = this.stateMap.remove(u);
        return oldValue != null;
    }

    private InputObjectState read(Uid u, String tn, int state) throws ObjectStoreException {
        byte[] data = (byte[])this.stateMap.get(u);
        if (data != null) {
            InputObjectState new_image = new InputObjectState(u, tn, data);
            return new_image;
        }
        return null;
    }

    private boolean write(Uid u, String tn, OutputObjectState buff, int state) throws ObjectStoreException {
        this.stateMap.put(u, buff.buffer());
        return true;
    }

    private int getState(Uid u) {
        if (this.stateMap.containsKey(u)) {
            return 1;
        }
        return -1;
    }

    private void packUid(OutputObjectState store, Uid uid) throws ObjectStoreException {
        try {
            UidHelper.packInto(uid, store);
        }
        catch (IOException e) {
            throw new ObjectStoreException("TypedVolatileStore::packUid - could not pack uid: " + e.getMessage());
        }
    }

    private void packString(OutputObjectState store, String s) throws ObjectStoreException {
        try {
            store.packString(s);
        }
        catch (IOException e) {
            throw new ObjectStoreException("TypedVolatileStore::packString - could not pack string: " + e.getMessage());
        }
    }
}

