/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jta.recovery.arjunacore;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.arjuna.objectstore.RecoveryStore;
import com.arjuna.ats.arjuna.objectstore.StoreManager;
import com.arjuna.ats.arjuna.recovery.RecoveryModule;
import com.arjuna.ats.arjuna.recovery.TransactionStatusConnectionManager;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.arjuna.state.OutputObjectState;
import com.arjuna.ats.internal.arjuna.common.UidHelper;
import com.arjuna.ats.internal.jta.recovery.arjunacore.RecoverConnectableAtomicAction;
import com.arjuna.ats.internal.jta.xa.XID;
import com.arjuna.ats.jta.common.JTAEnvironmentBean;
import com.arjuna.ats.jta.logging.jtaLogger;
import com.arjuna.ats.jta.xa.XidImple;
import com.arjuna.common.internal.util.propertyservice.BeanPopulator;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.transaction.xa.Xid;

public class CommitMarkableResourceRecordRecoveryModule
implements RecoveryModule {
    private static final String ATOMIC_ACTION_TYPE = RecoverConnectableAtomicAction.ATOMIC_ACTION_TYPE;
    private static final String CONNECTABLE_ATOMIC_ACTION_TYPE = RecoverConnectableAtomicAction.CONNECTABLE_ATOMIC_ACTION_TYPE;
    private InitialContext context;
    private List<String> jndiNamesToContact = new ArrayList<String>();
    private Map<Xid, String> committedXidsToJndiNames = new HashMap<Xid, String>();
    private List<String> queriedResourceManagers = new ArrayList<String>();
    private static RecoveryStore recoveryStore = null;
    private Map<String, Map<Xid, Uid>> jndiNamesToPossibleXidsForGC = new HashMap<String, Map<Xid, Uid>>();
    private String whereFilter;
    private TransactionStatusConnectionManager transactionStatusConnectionMgr;
    private static JTAEnvironmentBean jtaEnvironmentBean = BeanPopulator.getDefaultInstance(JTAEnvironmentBean.class);
    private Map<String, String> commitMarkableResourceTableNameMap = jtaEnvironmentBean.getCommitMarkableResourceTableNameMap();
    private Map<String, List<Xid>> completedBranches = new HashMap<String, List<Xid>>();
    private boolean inFirstPass;
    private static String defaultTableName = jtaEnvironmentBean.getDefaultCommitMarkableTableName();

    public CommitMarkableResourceRecordRecoveryModule() throws NamingException, ObjectStoreException {
        List<String> xaRecoveryNodes;
        this.context = new InitialContext();
        JTAEnvironmentBean jtaEnvironmentBean = BeanPopulator.getDefaultInstance(JTAEnvironmentBean.class);
        this.jndiNamesToContact.addAll(jtaEnvironmentBean.getCommitMarkableResourceJNDINames());
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace("CommitMarkableResourceRecordRecoveryModule::list to contact");
            for (String jndiName : this.jndiNamesToContact) {
                tsLogger.logger.trace("CommitMarkableResourceRecordRecoveryModule::in list: " + jndiName);
            }
            tsLogger.logger.trace("CommitMarkableResourceRecordRecoveryModule::list to contact complete");
        }
        if ((xaRecoveryNodes = jtaEnvironmentBean.getXaRecoveryNodes()).size() == 0) {
            jtaLogger.i18NLogger.info_recovery_noxanodes();
            this.whereFilter = "";
        } else if (xaRecoveryNodes.contains("*")) {
            this.whereFilter = "";
        } else {
            StringBuffer buffer = new StringBuffer();
            Iterator<String> iterator = xaRecoveryNodes.iterator();
            while (iterator.hasNext()) {
                buffer.append("'" + iterator.next() + "',");
            }
            this.whereFilter = " where transactionManagerID in ( " + buffer.substring(0, buffer.length() - 1) + ")";
        }
        if (recoveryStore == null) {
            recoveryStore = StoreManager.getRecoveryStore();
        }
        this.transactionStatusConnectionMgr = new TransactionStatusConnectionManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyOfCompletedBranch(String commitMarkableResourceJndiName, Xid xid) {
        Map<String, List<Xid>> map = this.completedBranches;
        synchronized (map) {
            List<Xid> completedXids = this.completedBranches.get(commitMarkableResourceJndiName);
            if (completedXids == null) {
                completedXids = new ArrayList<Xid>();
                this.completedBranches.put(commitMarkableResourceJndiName, completedXids);
            }
            completedXids.add(xid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void periodicWorkFirstPass() {
        if (this.inFirstPass) {
            return;
        }
        this.inFirstPass = true;
        HashMap<String, List<Xid>> completedBranches2 = new HashMap<String, List<Xid>>();
        Map<String, List<Xid>> map = this.completedBranches;
        synchronized (map) {
            completedBranches2.putAll(this.completedBranches);
            this.completedBranches.clear();
        }
        for (Map.Entry entry : completedBranches2.entrySet()) {
            this.delete((String)entry.getKey(), (List)entry.getValue());
        }
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace("CommitMarkableResourceRecordRecoveryModule::periodicWorkFirstPass");
        }
        this.committedXidsToJndiNames.clear();
        this.queriedResourceManagers.clear();
        this.jndiNamesToPossibleXidsForGC.clear();
        try {
            String commitMarkableResourceJndiName;
            RecoverConnectableAtomicAction rcaa;
            InputObjectState state;
            Uid currentUid;
            for (String string : this.jndiNamesToContact) {
                try {
                    if (tsLogger.logger.isTraceEnabled()) {
                        tsLogger.logger.trace("CommitMarkableResourceRecordRecoveryModule::connecting to: " + string);
                    }
                    DataSource dataSource = (DataSource)this.context.lookup(string);
                    Connection connection = dataSource.getConnection();
                    try {
                        Statement createStatement = connection.createStatement();
                        try {
                            String tableName = this.commitMarkableResourceTableNameMap.get(string);
                            if (tableName == null) {
                                tableName = defaultTableName;
                            }
                            ResultSet rs = createStatement.executeQuery("SELECT xid,actionuid from " + tableName + this.whereFilter);
                            try {
                                int i = 0;
                                while (rs.next()) {
                                    ++i;
                                    byte[] xidAsBytes = rs.getBytes(1);
                                    ByteArrayInputStream bais = new ByteArrayInputStream(xidAsBytes);
                                    DataInputStream dis = new DataInputStream(bais);
                                    XID _theXid = new XID();
                                    _theXid.formatID = dis.readInt();
                                    _theXid.gtrid_length = dis.readInt();
                                    _theXid.bqual_length = dis.readInt();
                                    int dataLength = dis.readInt();
                                    _theXid.data = new byte[dataLength];
                                    dis.read(_theXid.data, 0, dataLength);
                                    XidImple xid = new XidImple(_theXid);
                                    byte[] actionuidAsBytes = new byte[28];
                                    byte[] bytes = rs.getBytes(2);
                                    System.arraycopy(bytes, 0, actionuidAsBytes, 0, bytes.length);
                                    this.committedXidsToJndiNames.put(xid, string);
                                    if (tsLogger.logger.isTraceEnabled()) {
                                        tsLogger.logger.trace("committedXidsToJndiNames.put" + xid + " " + string);
                                    }
                                    Uid actionuid = new Uid(actionuidAsBytes);
                                    Map<Xid, Uid> map2 = this.jndiNamesToPossibleXidsForGC.get(string);
                                    if (map2 == null) {
                                        map2 = new HashMap<Xid, Uid>();
                                        this.jndiNamesToPossibleXidsForGC.put(string, map2);
                                    }
                                    map2.put(xid, actionuid);
                                }
                            }
                            finally {
                                try {
                                    rs.close();
                                }
                                catch (SQLException e) {
                                    tsLogger.logger.warn((Object)"Could not close resultset", e);
                                }
                            }
                        }
                        finally {
                            try {
                                createStatement.close();
                            }
                            catch (SQLException e) {
                                tsLogger.logger.warn((Object)"Could not close statement", e);
                            }
                        }
                        this.queriedResourceManagers.add(string);
                    }
                    finally {
                        try {
                            connection.close();
                        }
                        catch (SQLException e) {
                            tsLogger.logger.warn((Object)"Could not close connection", e);
                        }
                    }
                }
                catch (NamingException e) {
                    tsLogger.logger.debug((Object)("Could not lookup CommitMarkableResource: " + string), e);
                }
                catch (SQLException e) {
                    tsLogger.logger.warn((Object)"Could not handle connection", e);
                }
                catch (IOException e) {
                    tsLogger.logger.warn((Object)"Could not lookup write data to select", e);
                }
            }
            try {
                InputObjectState inputObjectState = new InputObjectState();
                recoveryStore.allObjUids(CONNECTABLE_ATOMIC_ACTION_TYPE, inputObjectState);
                currentUid = UidHelper.unpackFrom(inputObjectState);
                while (Uid.nullUid().notEquals(currentUid)) {
                    state = recoveryStore.read_committed(currentUid, ATOMIC_ACTION_TYPE);
                    if (state != null) {
                        if (!recoveryStore.remove_committed(currentUid, CONNECTABLE_ATOMIC_ACTION_TYPE)) {
                            tsLogger.logger.debug("Could not remove a: " + CONNECTABLE_ATOMIC_ACTION_TYPE + " uid: " + currentUid);
                        }
                    } else {
                        state = recoveryStore.read_committed(currentUid, CONNECTABLE_ATOMIC_ACTION_TYPE);
                        if (state != null) {
                            rcaa = new RecoverConnectableAtomicAction(CONNECTABLE_ATOMIC_ACTION_TYPE, currentUid, state);
                            if (rcaa.containsIncompleteCommitMarkableResourceRecord()) {
                                commitMarkableResourceJndiName = rcaa.getCommitMarkableResourceJndiName();
                                if (this.queriedResourceManagers.contains(commitMarkableResourceJndiName)) {
                                    this.moveRecord(currentUid, CONNECTABLE_ATOMIC_ACTION_TYPE, ATOMIC_ACTION_TYPE);
                                }
                            } else {
                                if (tsLogger.logger.isTraceEnabled()) {
                                    tsLogger.logger.trace("Moving " + currentUid + " back to being an AA");
                                }
                                this.moveRecord(currentUid, CONNECTABLE_ATOMIC_ACTION_TYPE, ATOMIC_ACTION_TYPE);
                            }
                        }
                    }
                    currentUid = UidHelper.unpackFrom(inputObjectState);
                }
            }
            catch (ObjectStoreException | IOException exception) {
                tsLogger.logger.warn((Object)"Could not query objectstore: ", exception);
            }
            if (tsLogger.logger.isDebugEnabled()) {
                tsLogger.logger.debug("processing " + ATOMIC_ACTION_TYPE + " transactions");
            }
            try {
                InputObjectState inputObjectState = new InputObjectState();
                recoveryStore.allObjUids(ATOMIC_ACTION_TYPE, inputObjectState);
                currentUid = UidHelper.unpackFrom(inputObjectState);
                while (Uid.nullUid().notEquals(currentUid)) {
                    if (!this.isTransactionInMidFlight(this.transactionStatusConnectionMgr.getTransactionStatus(ATOMIC_ACTION_TYPE, currentUid)) && (state = recoveryStore.read_committed(currentUid, ATOMIC_ACTION_TYPE)) != null && (rcaa = new RecoverConnectableAtomicAction(ATOMIC_ACTION_TYPE, currentUid, state)).containsIncompleteCommitMarkableResourceRecord()) {
                        commitMarkableResourceJndiName = rcaa.getCommitMarkableResourceJndiName();
                        if (!this.queriedResourceManagers.contains(commitMarkableResourceJndiName)) {
                            this.moveRecord(currentUid, ATOMIC_ACTION_TYPE, CONNECTABLE_ATOMIC_ACTION_TYPE);
                        } else {
                            rcaa.updateCommitMarkableResourceRecord(this.committedXidsToJndiNames.get(rcaa.getXid()) != null);
                            this.moveRecord(currentUid, ATOMIC_ACTION_TYPE, CONNECTABLE_ATOMIC_ACTION_TYPE);
                        }
                    }
                    currentUid = UidHelper.unpackFrom(inputObjectState);
                }
            }
            catch (ObjectStoreException | IOException exception) {
                tsLogger.logger.warn((Object)"Could not query objectstore: ", exception);
            }
        }
        catch (IllegalStateException e) {
            tsLogger.logger.debug((Object)("Could not lookup datasource, AS is shutting down: " + e.getMessage()), e);
        }
        this.inFirstPass = false;
    }

    @Override
    public synchronized void periodicWorkSecondPass() {
        HashSet<Uid> preparedAtomicActions = new HashSet<Uid>();
        InputObjectState aa_uids = new InputObjectState();
        try {
            if (recoveryStore.allObjUids(ATOMIC_ACTION_TYPE, aa_uids)) {
                preparedAtomicActions.addAll(this.convertToList(aa_uids));
                if (recoveryStore.allObjUids(CONNECTABLE_ATOMIC_ACTION_TYPE, aa_uids)) {
                    preparedAtomicActions.addAll(this.convertToList(aa_uids));
                    for (String jndiName : this.queriedResourceManagers) {
                        ArrayList<Xid> toDelete = new ArrayList<Xid>();
                        Map<Xid, Uid> map = this.jndiNamesToPossibleXidsForGC.get(jndiName);
                        if (map != null) {
                            for (Map.Entry<Xid, Uid> entry : map.entrySet()) {
                                Xid next = entry.getKey();
                                Uid uid = entry.getValue();
                                if (preparedAtomicActions.contains(uid)) continue;
                                toDelete.add(next);
                            }
                        }
                        this.delete(jndiName, toDelete);
                    }
                } else {
                    tsLogger.logger.warn("Could not read data from object store");
                }
            } else {
                tsLogger.logger.warn("Could not read " + CONNECTABLE_ATOMIC_ACTION_TYPE + " from object store");
            }
        }
        catch (ObjectStoreException e) {
            tsLogger.logger.warn((Object)("Could not read " + ATOMIC_ACTION_TYPE + " from object store"), e);
        }
    }

    public synchronized boolean wasCommitted(String jndiName, Xid xid) throws ObjectStoreException {
        if (!this.queriedResourceManagers.contains(jndiName) || this.committedXidsToJndiNames.get(xid) == null) {
            this.periodicWorkFirstPass();
        }
        if (!this.queriedResourceManagers.contains(jndiName)) {
            throw new ObjectStoreException(jndiName + " was not online");
        }
        String committed = this.committedXidsToJndiNames.get(xid);
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace("wasCommitted" + xid + " " + committed);
        }
        return committed != null;
    }

    private List<Uid> convertToList(InputObjectState aa_uids) {
        ArrayList<Uid> uids = new ArrayList<Uid>();
        boolean moreUids = true;
        while (moreUids) {
            Uid theUid = null;
            try {
                theUid = UidHelper.unpackFrom(aa_uids);
                if (theUid.equals(Uid.nullUid())) {
                    moreUids = false;
                    continue;
                }
                Uid newUid = new Uid(theUid);
                if (tsLogger.logger.isDebugEnabled()) {
                    tsLogger.logger.debug("found transaction " + newUid);
                }
                uids.add(newUid);
            }
            catch (IOException ex) {
                moreUids = false;
            }
        }
        return uids;
    }

    private boolean isTransactionInMidFlight(int status) {
        boolean inFlight = false;
        switch (status) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                inFlight = true;
                break;
            }
            case 4: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                inFlight = false;
                break;
            }
            default: {
                inFlight = false;
            }
        }
        return inFlight;
    }

    private void moveRecord(Uid uid, String from, String to) throws ObjectStoreException {
        RecoveryStore recoveryStore = StoreManager.getRecoveryStore();
        InputObjectState state = recoveryStore.read_committed(uid, from);
        if (state != null) {
            if (!recoveryStore.write_committed(uid, to, new OutputObjectState(state))) {
                tsLogger.logger.error("Could not move an: " + to + " uid: " + uid);
            } else if (!recoveryStore.remove_committed(uid, from)) {
                tsLogger.logger.error("Could not remove a: " + from + " uid: " + uid);
            }
        } else {
            tsLogger.logger.error("Could not read an: " + from + " uid: " + uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void delete(String jndiName, List<Xid> completedXids) {
        int batchSize = jtaEnvironmentBean.getCommitMarkableResourceRecordDeleteBatchSize();
        Integer integer = jtaEnvironmentBean.getCommitMarkableResourceRecordDeleteBatchSizeMap().get(jndiName);
        if (integer != null) {
            batchSize = integer;
        }
        try {
            Connection connection;
            while (completedXids.size() > 0) {
                int sendingSize = batchSize < 0 ? completedXids.size() : (completedXids.size() < batchSize ? completedXids.size() : batchSize);
                StringBuffer buffer = new StringBuffer();
                for (int i = 0; i < sendingSize; ++i) {
                    buffer.append("?,");
                }
                if (buffer.length() <= 0) continue;
                connection = null;
                DataSource dataSource = (DataSource)this.context.lookup(jndiName);
                try {
                    connection = dataSource.getConnection();
                    connection.setAutoCommit(false);
                    String tableName = this.commitMarkableResourceTableNameMap.get(jndiName);
                    if (tableName == null) {
                        tableName = defaultTableName;
                    }
                    String sql = "DELETE from " + tableName + " where xid in (" + buffer.substring(0, buffer.length() - 1) + ")";
                    if (tsLogger.logger.isTraceEnabled()) {
                        tsLogger.logger.trace("Attempting to delete number of entries: " + buffer.length());
                    }
                    PreparedStatement prepareStatement = connection.prepareStatement(sql);
                    ArrayList<XidImple> deleted = new ArrayList<XidImple>();
                    try {
                        for (int i = 0; i < sendingSize; ++i) {
                            XidImple xid = (XidImple)completedXids.remove(0);
                            deleted.add(xid);
                            XID toSave = xid.getXID();
                            ByteArrayOutputStream baos = new ByteArrayOutputStream();
                            DataOutputStream dos = new DataOutputStream(baos);
                            dos.writeInt(toSave.formatID);
                            dos.writeInt(toSave.gtrid_length);
                            dos.writeInt(toSave.bqual_length);
                            dos.writeInt(toSave.data.length);
                            dos.write(toSave.data);
                            dos.flush();
                            prepareStatement.setBytes(i + 1, baos.toByteArray());
                        }
                        int executeUpdate = prepareStatement.executeUpdate();
                        if (executeUpdate != sendingSize) {
                            tsLogger.logger.error("Update was not successful, expected: " + sendingSize + " actual:" + executeUpdate);
                            connection.rollback();
                        } else {
                            connection.commit();
                            this.committedXidsToJndiNames.keySet().removeAll(deleted);
                        }
                    }
                    catch (IOException e) {
                        tsLogger.logger.warn((Object)"Could not generate prepareStatement paramaters", e);
                    }
                    finally {
                        try {
                            prepareStatement.close();
                        }
                        catch (SQLException e) {
                            tsLogger.logger.warn((Object)"Could not close the prepared statement", e);
                        }
                    }
                    if (connection == null) continue;
                }
                catch (SQLException e) {
                    tsLogger.logger.warn((Object)"Could not handle the connection", e);
                    return;
                }
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    tsLogger.logger.warn((Object)"Could not close the connection", e);
                }
            }
            return;
            finally {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (SQLException e) {
                        tsLogger.logger.warn((Object)"Could not close the connection", e);
                    }
                }
            }
        }
        catch (NamingException e) {
            tsLogger.logger.warn("Could not lookup commitMarkable: " + jndiName);
            tsLogger.logger.debug((Object)("Could not lookup commitMarkable: " + jndiName), e);
            return;
        }
        catch (IllegalStateException e) {
            tsLogger.logger.debug((Object)("Could not lookup datasource, AS is shutting down: " + e.getMessage()), e);
        }
    }
}

