/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jta.recovery.arjunacore;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
import com.arjuna.ats.arjuna.objectstore.RecoveryStore;
import com.arjuna.ats.arjuna.objectstore.StoreManager;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.internal.jta.recovery.arjunacore.RecoverConnectableAtomicAction;
import com.arjuna.ats.internal.jta.transaction.arjunacore.AtomicAction;
import com.arjuna.ats.jta.logging.jtaLogger;
import com.arjuna.ats.jta.recovery.XAResourceOrphanFilter;
import com.arjuna.ats.jta.utils.XAHelper;
import com.arjuna.ats.jta.xa.XidImple;
import java.io.IOException;
import javax.transaction.xa.Xid;

public class JTATransactionLogXAResourceOrphanFilter
implements XAResourceOrphanFilter {
    @Override
    public XAResourceOrphanFilter.Vote checkXid(Xid xid) {
        if (xid.getFormatId() != 131077) {
            return XAResourceOrphanFilter.Vote.ABSTAIN;
        }
        try {
            if (this.transactionLog(xid)) {
                return XAResourceOrphanFilter.Vote.LEAVE_ALONE;
            }
        }
        catch (ObjectStoreException | IOException e) {
            jtaLogger.i18NLogger.warn_could_not_access_object_store(e);
            return XAResourceOrphanFilter.Vote.LEAVE_ALONE;
        }
        return XAResourceOrphanFilter.Vote.ABSTAIN;
    }

    private boolean containsCommitMarkableResourceRecord(Uid u) throws ObjectStoreException, IOException {
        InputObjectState state = StoreManager.getRecoveryStore().read_committed(u, RecoverConnectableAtomicAction.CONNECTABLE_ATOMIC_ACTION_TYPE);
        if (state != null) {
            RecoverConnectableAtomicAction rcaa = new RecoverConnectableAtomicAction(RecoverConnectableAtomicAction.CONNECTABLE_ATOMIC_ACTION_TYPE, u, state);
            return rcaa.containsIncompleteCommitMarkableResourceRecord() || rcaa.wasConfirmedCommitted();
        }
        return false;
    }

    private boolean transactionLog(Xid xid) throws ObjectStoreException, IOException {
        RecoveryStore recoveryStore = StoreManager.getRecoveryStore();
        String transactionType = new AtomicAction().type();
        XidImple theXid = new XidImple(xid);
        Uid u = theXid.getTransactionUid();
        if (jtaLogger.logger.isDebugEnabled()) {
            jtaLogger.logger.debug("Checking whether Xid " + theXid + " exists in ObjectStore.");
        }
        if (!u.equals(Uid.nullUid())) {
            if (jtaLogger.logger.isDebugEnabled()) {
                jtaLogger.logger.debug("Looking for " + u + " and " + transactionType);
            }
            if (this.containsCommitMarkableResourceRecord(u) || recoveryStore.currentState(u, transactionType) != -1) {
                if (jtaLogger.logger.isDebugEnabled()) {
                    jtaLogger.logger.debug("Found record for " + theXid);
                }
                return true;
            }
            if (jtaLogger.logger.isDebugEnabled()) {
                jtaLogger.logger.debug("No record found for " + theXid);
            }
        } else {
            jtaLogger.i18NLogger.info_recovery_notaxid(XAHelper.xidToString(xid));
        }
        return false;
    }
}

