/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jta.recovery.arjunacore;

import com.arjuna.ats.arjuna.AtomicAction;
import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.internal.arjuna.Header;
import com.arjuna.ats.internal.jta.resources.arjunacore.CommitMarkableResourceRecord;
import com.arjuna.ats.jta.xa.XidImple;
import java.io.IOException;
import javax.transaction.xa.Xid;

public class RecoverConnectableAtomicAction
extends AtomicAction {
    public static final String ATOMIC_ACTION_TYPE = new AtomicAction().type();
    public static final String CONNECTABLE_ATOMIC_ACTION_TYPE = ATOMIC_ACTION_TYPE + "Connectable";
    private String jndiName;
    private String recoveringAs;
    private Xid xid;
    private boolean hasCompleted;
    private boolean wasCommitted;

    public RecoverConnectableAtomicAction(String type, Uid rcvUid, InputObjectState os) throws ObjectStoreException, IOException {
        super(rcvUid);
        this.recoveringAs = type;
        Header hdr = new Header();
        this.unpackHeader(os, hdr);
        os.unpackBoolean();
        int record_type = os.unpackInt();
        if (record_type == 50) {
            this.jndiName = os.unpackString();
            this.xid = XidImple.unpack(os);
            this.hasCompleted = os.unpackBoolean();
            if (this.hasCompleted) {
                this.wasCommitted = os.unpackBoolean();
            }
        }
    }

    @Override
    public String type() {
        return this.recoveringAs;
    }

    public boolean containsIncompleteCommitMarkableResourceRecord() {
        return this.jndiName != null && !this.hasCompleted;
    }

    public String getCommitMarkableResourceJndiName() {
        return this.jndiName;
    }

    public Xid getXid() {
        return this.xid;
    }

    public void updateCommitMarkableResourceRecord(boolean committed) {
        this.activate();
        CommitMarkableResourceRecord peekFront = (CommitMarkableResourceRecord)this.preparedList.peekFront();
        peekFront.updateOutcome(committed);
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace("Moving " + this.get_uid() + " to an AAR so it won't get processed this time");
        }
        this.deactivate();
    }

    public boolean wasConfirmedCommitted() {
        return this.wasCommitted;
    }
}

