/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.codegenerate.util;

import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class CodeDateUtils {
    public static final String DATESTYLE = "yyyyMMddHHmmss";
    public static final String DATESTYLE_EX = "yyyy-MM-dd_HH-mm-ss";
    public static final String DATESTYLE_ = "yyyy-MM-dd";
    public static final String DATESTYLE_YEAR_MONTH = "yyyyMM";
    public static final String DATESTYLE_SHORT = "yyyyMMdd";
    public static final String DATESTYLE_SHORT_EX = "yyyy/MM/dd";
    public static final String DATESTYLE_YEAR_MONTH_EX = "yyyy/MM";
    public static final String DATESTYLE_DETAIL = "yyyyMMddHHmmssSSS";

    public static String dateToString(Date date) {
        if (date == null) {
            return "";
        }
        return CodeDateUtils.FormatDate(date, "yyyy-MM-dd HH:mm:ss");
    }

    public static String dateToStringShort(Date date) {
        if (date == null) {
            return "";
        }
        return CodeDateUtils.FormatDate(date, DATESTYLE_);
    }

    public static long diffTwoDate(Date date1, Date date2) {
        long l1 = date1.getTime();
        long l2 = date2.getTime();
        return l1 - l2;
    }

    public static int diffTwoDateDay(Date date1, Date date2) {
        long l1 = date1.getTime();
        long l2 = date2.getTime();
        int diff = Integer.parseInt("" + (l1 - l2) / 3600L / 24L / 1000L);
        return diff;
    }

    public static String FormatDate(Date date, String sf) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat dateformat = new SimpleDateFormat(sf);
        return dateformat.format(date);
    }

    public static String getCurrDate() {
        Date date_time = new Date();
        return CodeDateUtils.FormatDate(date_time, DATESTYLE_);
    }

    public static Date getCurrDateTime() {
        return new Date(System.currentTimeMillis());
    }

    public static String getCurrTime() {
        Date date_time = new Date();
        return CodeDateUtils.FormatDate(date_time, "yyyy-MM-dd HH:mm:ss");
    }

    public static String getDate10to8(String str) {
        String y = str.substring(0, 4);
        String m = str.substring(5, 7);
        String d = str.substring(8, 10);
        return String.valueOf(y) + m + d;
    }

    public static String getDate8to10(String str) {
        String y = str.substring(0, 4);
        String m = str.substring(4, 6);
        String d = str.substring(6, 8);
        return String.valueOf(y) + "-" + m + "-" + d;
    }

    public static String getDay(Date date) {
        return CodeDateUtils.FormatDate(date, "dd");
    }

    public static String getHour(Date date) {
        return CodeDateUtils.FormatDate(date, "HH");
    }

    public static String getMinute(Date date) {
        return CodeDateUtils.FormatDate(date, "mm");
    }

    public static String getMonth(Date date) {
        return CodeDateUtils.FormatDate(date, "MM");
    }

    public static int getMonth(Date start, Date end) {
        if (start.after(end)) {
            Date t = start;
            start = end;
            end = t;
        }
        Calendar startCalendar = Calendar.getInstance();
        startCalendar.setTime(start);
        Calendar endCalendar = Calendar.getInstance();
        endCalendar.setTime(end);
        Calendar temp = Calendar.getInstance();
        temp.setTime(end);
        temp.add(5, 1);
        int year = endCalendar.get(1) - startCalendar.get(1);
        int month = endCalendar.get(2) - startCalendar.get(2);
        if (startCalendar.get(5) == 1 && temp.get(5) == 1) {
            return year * 12 + month + 1;
        }
        if (startCalendar.get(5) != 1 && temp.get(5) == 1) {
            return year * 12 + month;
        }
        if (startCalendar.get(5) == 1 && temp.get(5) != 1) {
            return year * 12 + month;
        }
        return year * 12 + month - 1 < 0 ? 0 : year * 12 + month;
    }

    public static String getSecond(Date date) {
        return CodeDateUtils.FormatDate(date, "ss");
    }

    public static String getTime(String year, String month) {
        String time = "";
        int len = 31;
        int iYear = Integer.parseInt(year);
        int iMonth = Integer.parseInt(month);
        if (iMonth == 4 || iMonth == 6 || iMonth == 9 || iMonth == 11) {
            len = 30;
        }
        if (iMonth == 2) {
            len = 28;
            if (iYear % 4 == 0 && iYear % 100 == 0 && iYear % 400 == 0 || iYear % 4 == 0 && iYear % 100 != 0) {
                len = 29;
            }
        }
        time = String.valueOf(year) + "-" + month + "-" + String.valueOf(len);
        return time;
    }

    public static String getYear(Date date) {
        return CodeDateUtils.FormatDate(date, "yyyy");
    }

    public static void main(String[] args) {
        CodeDateUtils d = new CodeDateUtils();
        String strDate = "2007-02-11";
        Date aa = CodeDateUtils.stringToDateShort(strDate);
        CodeDateUtils ddd = new CodeDateUtils();
    }

    public static Date stringToDate(String dateString) {
        String sf;
        if (dateString == null || dateString.trim().length() == 0) {
            return null;
        }
        String datestr = dateString.trim();
        Date dt = CodeDateUtils.stringToDate(datestr, sf = "yyyy-MM-dd HH:mm:ss");
        if (dt == null) {
            dt = CodeDateUtils.stringToDate(datestr, DATESTYLE_);
        }
        if (dt == null) {
            dt = CodeDateUtils.stringToDate(datestr, DATESTYLE_SHORT);
        }
        return dt;
    }

    public static Date stringToDate(String dateString, String sf) {
        ParsePosition pos = new ParsePosition(0);
        SimpleDateFormat sdf = new SimpleDateFormat(sf);
        Date dt = sdf.parse(dateString, pos);
        return dt;
    }

    public static Date stringToDateShort(String dateString) {
        String sf = DATESTYLE_;
        Date dt = CodeDateUtils.stringToDate(dateString, sf);
        return dt;
    }

    public String getBeginDate(String granularity, String statisticDate) {
        String beginDate = "";
        Date date = CodeDateUtils.stringToDateShort(statisticDate);
        Date beginDateTemp = null;
        if (granularity.equals("1")) {
            beginDateTemp = date;
        }
        if (granularity.equals("2")) {
            beginDateTemp = this.getWeekBegin(date);
        }
        if (granularity.equals("3")) {
            beginDateTemp = this.getPeriodBegin(date);
        } else if (granularity.equals("4")) {
            beginDateTemp = this.getMonthBegin(date);
        } else if (granularity.equals("5")) {
            beginDateTemp = this.getSeasonBegin(date);
        } else if (granularity.equals("6")) {
            beginDateTemp = this.getHalfYearBegin(date);
        } else if (granularity.equals("7")) {
            beginDateTemp = this.getYearBegin(date);
        }
        beginDate = CodeDateUtils.dateToStringShort(beginDateTemp);
        return beginDate;
    }

    public String getDateChangeALL(String currentTime, String type, int iQuantity) {
        Date curr = null;
        String newtype = "";
        if (currentTime.length() == 10) {
            curr = CodeDateUtils.stringToDateShort(currentTime);
        }
        if (currentTime.length() > 10) {
            curr = CodeDateUtils.stringToDate(currentTime);
        }
        if (type.equals("1")) {
            newtype = "d";
        } else if (type.equals("2")) {
            iQuantity *= 7;
            newtype = "d";
        } else if (type.equals("3")) {
            iQuantity *= 10;
            newtype = "d";
        } else if (type.equals("4")) {
            newtype = "m";
        } else if (type.equals("5")) {
            iQuantity *= 3;
            newtype = "m";
        } else if (type.equals("6")) {
            iQuantity *= 6;
            newtype = "m";
        } else {
            newtype = type.equals("7") ? "y" : "d";
        }
        Date change = this.getDateChangeTime(curr, newtype, iQuantity);
        return CodeDateUtils.dateToStringShort(change);
    }

    public Date getDateChangeTime(Date currentTime, String type, int iQuantity) {
        int year = Integer.parseInt(CodeDateUtils.FormatDate(currentTime, "yyyy"));
        int month = Integer.parseInt(CodeDateUtils.FormatDate(currentTime, "MM"));
        int day = Integer.parseInt(CodeDateUtils.FormatDate(currentTime, "dd"));
        int hour = Integer.parseInt(CodeDateUtils.FormatDate(currentTime, "HH"));
        int mi = Integer.parseInt(CodeDateUtils.FormatDate(currentTime, "mm"));
        int ss = Integer.parseInt(CodeDateUtils.FormatDate(currentTime, "ss"));
        GregorianCalendar gc = new GregorianCalendar(year, --month, day, hour, mi, ss);
        if (type.equalsIgnoreCase("y")) {
            gc.add(1, iQuantity);
        } else if (type.equalsIgnoreCase("m")) {
            gc.add(2, iQuantity);
        } else if (type.equalsIgnoreCase("d")) {
            gc.add(5, iQuantity);
        } else if (type.equalsIgnoreCase("h")) {
            gc.add(10, iQuantity);
        } else if (type.equalsIgnoreCase("mi")) {
            gc.add(12, iQuantity);
        } else if (type.equalsIgnoreCase("s")) {
            gc.add(13, iQuantity);
        }
        return gc.getTime();
    }

    public String getDateChangeTime(String currentTime, String type, int iQuantity) {
        Date curr = CodeDateUtils.stringToDate(currentTime);
        curr = this.getDateChangeTime(curr, type, iQuantity);
        return CodeDateUtils.dateToString(curr);
    }

    public String getEndDate(String granularity, String statisticDate) {
        String beginDate = "";
        Date date = CodeDateUtils.stringToDateShort(statisticDate);
        Date beginDateTemp = null;
        if (granularity.equals("1")) {
            beginDateTemp = date;
        }
        if (granularity.equals("2")) {
            beginDateTemp = this.getWeekEnd(date);
        }
        if (granularity.equals("3")) {
            beginDateTemp = this.getPeriodEnd(date);
        } else if (granularity.equals("4")) {
            beginDateTemp = this.getMonthEnd(date);
        } else if (granularity.equals("5")) {
            beginDateTemp = this.getSeasonEnd(date);
        } else if (granularity.equals("6")) {
            beginDateTemp = this.getHalfYearEnd(date);
        } else if (granularity.equals("7")) {
            beginDateTemp = this.getYearEnd(date);
        }
        beginDate = CodeDateUtils.dateToStringShort(beginDateTemp);
        return beginDate;
    }

    public Date getHalfYearBegin(Date date) {
        int year = Integer.parseInt(CodeDateUtils.FormatDate(date, "yyyy"));
        int month = Integer.parseInt(CodeDateUtils.FormatDate(date, "MM"));
        String newDateStr = String.valueOf(CodeDateUtils.FormatDate(date, "yyyy")) + "-";
        newDateStr = month <= 6 ? String.valueOf(newDateStr) + "01-01" : String.valueOf(newDateStr) + "07-01";
        return CodeDateUtils.stringToDateShort(newDateStr);
    }

    public Date getHalfYearEnd(Date date) {
        int year = Integer.parseInt(CodeDateUtils.FormatDate(date, "yyyy"));
        int month = Integer.parseInt(CodeDateUtils.FormatDate(date, "MM"));
        String newDateStr = String.valueOf(CodeDateUtils.FormatDate(date, "yyyy")) + "-";
        newDateStr = month <= 6 ? String.valueOf(newDateStr) + "06-30" : String.valueOf(newDateStr) + "12-31";
        return CodeDateUtils.stringToDateShort(newDateStr);
    }

    public Date getMonthBegin(Date date) {
        String newDateStr = String.valueOf(CodeDateUtils.FormatDate(date, "yyyy-MM")) + "-01";
        return CodeDateUtils.stringToDateShort(newDateStr);
    }

    public Date getMonthEnd(Date date) {
        int year = Integer.parseInt(CodeDateUtils.FormatDate(date, "yyyy"));
        int month = Integer.parseInt(CodeDateUtils.FormatDate(date, "MM"));
        int day = Integer.parseInt(CodeDateUtils.FormatDate(date, "dd"));
        GregorianCalendar calendar = new GregorianCalendar(year, month - 1, day, 0, 0, 0);
        int monthLength = calendar.getActualMaximum(5);
        String newDateStr = String.valueOf(CodeDateUtils.FormatDate(date, "yyyy")) + "-" + CodeDateUtils.FormatDate(date, "MM") + "-";
        newDateStr = monthLength < 10 ? String.valueOf(newDateStr) + "0" + monthLength : String.valueOf(newDateStr) + monthLength;
        return CodeDateUtils.stringToDateShort(newDateStr);
    }

    public Date getPeriodBegin(Date date) {
        int days = Integer.parseInt(CodeDateUtils.FormatDate(date, "dd"));
        String newDateStr = String.valueOf(CodeDateUtils.FormatDate(date, "yyyy-MM")) + "-";
        newDateStr = days <= 10 ? String.valueOf(newDateStr) + "01" : (days <= 20 ? String.valueOf(newDateStr) + "11" : String.valueOf(newDateStr) + "21");
        return CodeDateUtils.stringToDateShort(newDateStr);
    }

    public Date getPeriodEnd(Date date) {
        int days = Integer.parseInt(CodeDateUtils.FormatDate(date, "dd"));
        String newDateStr = String.valueOf(CodeDateUtils.FormatDate(date, "yyyy-MM")) + "-";
        newDateStr = days <= 10 ? String.valueOf(newDateStr) + "10" : (days <= 20 ? String.valueOf(newDateStr) + "20" : CodeDateUtils.FormatDate(this.getMonthEnd(date), DATESTYLE_));
        return CodeDateUtils.stringToDateShort(newDateStr);
    }

    public Date getSeasonBegin(Date date) {
        int year = Integer.parseInt(CodeDateUtils.FormatDate(date, "yyyy"));
        int month = Integer.parseInt(CodeDateUtils.FormatDate(date, "MM"));
        String newDateStr = String.valueOf(CodeDateUtils.FormatDate(date, "yyyy")) + "-";
        if (month >= 1 && month <= 3) {
            newDateStr = String.valueOf(newDateStr) + "01-01";
        } else if (month >= 4 && month <= 6) {
            newDateStr = String.valueOf(newDateStr) + "04-01";
        } else if (month >= 7 && month <= 9) {
            newDateStr = String.valueOf(newDateStr) + "07-01";
        } else if (month >= 10 && month <= 12) {
            newDateStr = String.valueOf(newDateStr) + "10-01";
        }
        return CodeDateUtils.stringToDateShort(newDateStr);
    }

    public Date getSeasonEnd(Date date) {
        int year = Integer.parseInt(CodeDateUtils.FormatDate(date, "yyyy"));
        int month = Integer.parseInt(CodeDateUtils.FormatDate(date, "MM"));
        String newDateStr = String.valueOf(CodeDateUtils.FormatDate(date, "yyyy")) + "-";
        if (month >= 1 && month <= 3) {
            newDateStr = String.valueOf(newDateStr) + "03-31";
        } else if (month >= 4 && month <= 6) {
            newDateStr = String.valueOf(newDateStr) + "06-30";
        } else if (month >= 7 && month <= 9) {
            newDateStr = String.valueOf(newDateStr) + "09-30";
        } else if (month >= 10 && month <= 12) {
            newDateStr = String.valueOf(newDateStr) + "12-31";
        }
        return CodeDateUtils.stringToDateShort(newDateStr);
    }

    public String getTimedes(String granularity, String statisticDate) {
        String timedes = "";
        Date date = CodeDateUtils.stringToDateShort(statisticDate);
        String year = "";
        String month = "01";
        String day = "01";
        year = CodeDateUtils.getYear(date);
        month = CodeDateUtils.getMonth(date);
        day = CodeDateUtils.getDay(date);
        if (granularity.equals("1")) {
            timedes = statisticDate;
        } else if (granularity.equals("4")) {
            timedes = String.valueOf(year) + "\u5e74" + month + "\u6708";
        } else if (granularity.equals("8")) {
            String quarter = String.valueOf(month) + "-" + day;
            if (quarter.equals("03-31")) {
                timedes = String.valueOf(year) + "\u5e74 \u7b2c1\u5b63\u5ea6";
            } else if (quarter.equals("06-30")) {
                timedes = String.valueOf(year) + "\u5e74 \u7b2c2\u5b63\u5ea6";
            } else if (quarter.equals("09-30")) {
                timedes = String.valueOf(year) + "\u5e74 \u7b2c3\u5b63\u5ea6";
            } else if (quarter.equals("12-31")) {
                timedes = String.valueOf(year) + "\u5e74 \u7b2c4\u5b63\u5ea6";
            }
        } else if (granularity.equals("32")) {
            timedes = String.valueOf(year) + "\u5e74";
        }
        return timedes;
    }

    public Date getWeekBegin(Date date) {
        int year = Integer.parseInt(CodeDateUtils.FormatDate(date, "yyyy"));
        int month = Integer.parseInt(CodeDateUtils.FormatDate(date, "MM"));
        int day = Integer.parseInt(CodeDateUtils.FormatDate(date, "dd"));
        GregorianCalendar gc = new GregorianCalendar(year, --month, day);
        int week = 6;
        if (week == 0) {
            week = 7;
        }
        gc.add(5, 0 - week + 1);
        return gc.getTime();
    }

    public Date getWeekEnd(Date date) {
        int year = Integer.parseInt(CodeDateUtils.FormatDate(date, "yyyy"));
        int month = Integer.parseInt(CodeDateUtils.FormatDate(date, "MM"));
        int day = Integer.parseInt(CodeDateUtils.FormatDate(date, "dd"));
        GregorianCalendar gc = new GregorianCalendar(year, --month, day);
        int week = 6;
        if (week == 0) {
            week = 7;
        }
        gc.add(5, 7 - week);
        return gc.getTime();
    }

    public Date getYearBegin(Date date) {
        String newDateStr = String.valueOf(CodeDateUtils.FormatDate(date, "yyyy")) + "-01-01";
        return CodeDateUtils.stringToDateShort(newDateStr);
    }

    public Date getYearEnd(Date date) {
        String newDateStr = String.valueOf(CodeDateUtils.FormatDate(date, "yyyy")) + "-12-31";
        return CodeDateUtils.stringToDateShort(newDateStr);
    }

    public boolean IsXperiodEnd(Date date) {
        boolean flag = false;
        String day = CodeDateUtils.getDay(date);
        String month = CodeDateUtils.getMonth(date);
        if (day.equalsIgnoreCase("10")) {
            flag = true;
        } else if (day.equalsIgnoreCase("20")) {
            flag = true;
        }
        return flag;
    }

    public static String addDay(String s, int n) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(DATESTYLE_);
            Calendar cd = Calendar.getInstance();
            cd.setTime(sdf.parse(s));
            cd.add(5, n);
            return sdf.format(cd.getTime());
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String delDay(String s, int n) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(DATESTYLE_);
            Calendar cd = Calendar.getInstance();
            cd.setTime(sdf.parse(s));
            cd.add(5, -n);
            return sdf.format(cd.getTime());
        }
        catch (Exception e) {
            return null;
        }
    }
}

