/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.core;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.powermock.core.MockRepository;
import org.powermock.core.spi.MethodInvocationControl;
import org.powermock.core.spi.NewInvocationControl;
import org.powermock.reflect.exceptions.MethodNotFoundException;
import org.powermock.reflect.internal.TypeUtils;
import org.powermock.reflect.internal.WhiteboxImpl;

public class MockGateway {
    public static final Object PROCEED = new Object();
    public static final Object SUPPRESS = new Object();
    public static final String DONT_MOCK_NEXT_CALL = "DontMockNextCall";
    public static boolean MOCK_STANDARD_METHODS = true;
    public static boolean MOCK_GET_CLASS_METHOD = false;
    public static boolean MOCK_ANNOTATION_METHODS = false;

    public static Object newInstanceCall(Class<?> type, Object[] args, Class<?>[] sig) throws Throwable {
        NewInvocationControl<?> newInvocationControl = MockRepository.getNewInstanceControl(type);
        if (newInvocationControl != null) {
            if (type.isMemberClass() && Modifier.isStatic(type.getModifiers())) {
                if (args.length > 0 && (args[0] == null || args[args.length - 1] == null) && sig.length > 0) {
                    args = MockGateway.copyArgumentsForInnerOrLocalOrAnonymousClass(args, false);
                }
            } else if ((type.isLocalClass() || type.isAnonymousClass() || type.isMemberClass()) && args.length > 0 && sig.length > 0 && sig[0].equals(type.getEnclosingClass())) {
                args = MockGateway.copyArgumentsForInnerOrLocalOrAnonymousClass(args, true);
            }
            return newInvocationControl.invoke(type, args, sig);
        }
        if (MockRepository.shouldSuppressConstructor(WhiteboxImpl.getConstructor(type, (Class[])sig))) {
            return WhiteboxImpl.getFirstParentConstructor(type);
        }
        return PROCEED;
    }

    public static Object fieldCall(Object instanceOrClassContainingTheField, Class<?> classDefiningField, String fieldName, Class<?> fieldType) {
        if (MockRepository.shouldSuppressField(WhiteboxImpl.getField(classDefiningField, (String)fieldName))) {
            return TypeUtils.getDefaultValue(fieldType);
        }
        return PROCEED;
    }

    public static Object staticConstructorCall(String className) {
        if (MockRepository.shouldSuppressStaticInitializerFor(className)) {
            return "suppress";
        }
        return PROCEED;
    }

    public static Object constructorCall(Class<?> type, Object[] args, Class<?>[] sig) throws Throwable {
        Constructor constructor = WhiteboxImpl.getConstructor(type, (Class[])sig);
        if (MockRepository.shouldSuppressConstructor(constructor)) {
            return null;
        }
        return PROCEED;
    }

    public static Object methodCall(Object instance, String methodName, Object[] args, Class<?>[] sig, String returnTypeAsString) throws Throwable {
        return MockGateway.doMethodCall(instance, methodName, args, sig, returnTypeAsString);
    }

    public static Object methodCall(Class<?> type, String methodName, Object[] args, Class<?>[] sig, String returnTypeAsString) throws Throwable {
        return MockGateway.doMethodCall(type, methodName, args, sig, returnTypeAsString);
    }

    private static Object doMethodCall(Object object, String methodName, Object[] args, Class<?>[] sig, String returnTypeAsString) throws Throwable {
        if (!MockGateway.shouldMockMethod(methodName, sig)) {
            return PROCEED;
        }
        MockInvocation mockInvocation = new MockInvocation(object, methodName, sig);
        MethodInvocationControl methodInvocationControl = mockInvocation.getMethodInvocationControl();
        Object returnValue = null;
        if (MockGateway.isEqualsMethod(mockInvocation)) {
            returnValue = MockGateway.tryHandleEqualsMethod(mockInvocation);
        }
        if (returnValue != null) {
            return returnValue;
        }
        return MockGateway.doMethodCall(object, args, returnTypeAsString, mockInvocation, methodInvocationControl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object doMethodCall(Object object, Object[] args, String returnTypeAsString, MockInvocation mockInvocation, MethodInvocationControl methodInvocationControl) throws Throwable {
        Object returnValue;
        if (MockRepository.shouldSuppressMethod(mockInvocation.getMethod(), mockInvocation.getObjectType())) {
            returnValue = TypeUtils.getDefaultValue((String)returnTypeAsString);
        } else if (MockRepository.shouldStubMethod(mockInvocation.getMethod())) {
            returnValue = MockRepository.getMethodToStub(mockInvocation.getMethod());
        } else if (methodInvocationControl != null && methodInvocationControl.isMocked(mockInvocation.getMethod()) && MockGateway.shouldMockThisCall()) {
            returnValue = methodInvocationControl.invoke(object, mockInvocation.getMethod(), args);
            if (returnValue == SUPPRESS) {
                returnValue = TypeUtils.getDefaultValue((String)returnTypeAsString);
            }
        } else if (MockRepository.hasMethodProxy(mockInvocation.getMethod())) {
            InvocationHandler invocationHandler = MockRepository.removeMethodProxy(mockInvocation.getMethod());
            try {
                returnValue = invocationHandler.invoke(object, mockInvocation.getMethod(), args);
            }
            finally {
                MockRepository.putMethodProxy(mockInvocation.getMethod(), invocationHandler);
            }
        } else {
            returnValue = PROCEED;
        }
        return returnValue;
    }

    private static Object tryHandleEqualsMethod(MockInvocation mockInvocation) {
        if (mockInvocation.getMethod().getParameterTypes().length == 1 && mockInvocation.getMethod().getParameterTypes()[0] == Object.class && Modifier.isFinal(mockInvocation.getMethod().getModifiers())) {
            return PROCEED;
        }
        if (MockGateway.calledFromMockito()) {
            return PROCEED;
        }
        return null;
    }

    private static boolean isEqualsMethod(MockInvocation mockInvocation) {
        return "equals".equals(mockInvocation.getMethod().getName());
    }

    private static boolean calledFromMockito() {
        StackTraceElement[] stackTrace;
        for (StackTraceElement stackTraceElement : stackTrace = Thread.currentThread().getStackTrace()) {
            if (!stackTraceElement.getClassName().startsWith("org.mockito.")) continue;
            return true;
        }
        return false;
    }

    private static boolean shouldMockMethod(String methodName, Class<?>[] sig) {
        if (MockGateway.isJavaStandardMethod(methodName, sig) && !MOCK_STANDARD_METHODS) {
            return false;
        }
        if (MockGateway.isGetClassMethod(methodName, sig) && !MOCK_GET_CLASS_METHOD) {
            return false;
        }
        return !MockGateway.isAnnotationMethod(methodName, sig) || MOCK_ANNOTATION_METHODS;
    }

    private static boolean isJavaStandardMethod(String methodName, Class<?>[] sig) {
        return methodName.equals("equals") && sig.length == 1 || methodName.equals("hashCode") && sig.length == 0 || methodName.equals("toString") && sig.length == 0;
    }

    private static boolean isGetClassMethod(String methodName, Class<?>[] sig) {
        return methodName.equals("getClass") && sig.length == 0;
    }

    private static boolean isAnnotationMethod(String methodName, Class<?>[] sig) {
        return methodName.equals("isAnnotationPresent") && sig.length == 1 || methodName.equals("getAnnotation") && sig.length == 1;
    }

    private static boolean shouldMockThisCall() {
        Object shouldSkipMockingOfNextCall = MockRepository.getAdditionalState(DONT_MOCK_NEXT_CALL);
        boolean shouldMockThisCall = shouldSkipMockingOfNextCall == null;
        MockRepository.removeAdditionalState(DONT_MOCK_NEXT_CALL);
        return shouldMockThisCall;
    }

    private static Object[] copyArgumentsForInnerOrLocalOrAnonymousClass(Object[] args, boolean excludeEnclosingInstance) {
        int end;
        int start;
        Object[] newArgs = new Object[args.length - 1];
        int j = 0;
        if (args[0] == null || excludeEnclosingInstance) {
            start = 1;
            end = args.length;
        } else {
            start = 0;
            end = args.length - 1;
        }
        for (int i = start; i < end; ++i) {
            newArgs[j++] = args[i];
        }
        args = newArgs;
        return args;
    }

    private static class MockInvocation {
        private Object object;
        private String methodName;
        private Class<?>[] sig;
        private Class<?> objectType;
        private MethodInvocationControl methodInvocationControl;
        private Method method;

        public MockInvocation(Object object, String methodName, Class<?> ... sig) {
            this.object = object;
            this.methodName = methodName;
            this.sig = sig;
            this.init();
        }

        private static Method findMethodToInvoke(String methodName, Class<?>[] sig, Class<?> objectType) {
            Method method;
            try {
                method = WhiteboxImpl.getBestMethodCandidate(objectType, (String)methodName, (Class[])sig, (boolean)true);
            }
            catch (MethodNotFoundException e) {
                try {
                    method = WhiteboxImpl.getMethod(Class.class, (String)methodName, (Class[])sig);
                }
                catch (MethodNotFoundException e2) {
                    throw e;
                }
            }
            return method;
        }

        public Class<?> getObjectType() {
            return this.objectType;
        }

        public MethodInvocationControl getMethodInvocationControl() {
            return this.methodInvocationControl;
        }

        public Method getMethod() {
            return this.method;
        }

        private void init() {
            if (this.object instanceof Class) {
                this.objectType = (Class)this.object;
                this.methodInvocationControl = MockRepository.getStaticMethodInvocationControl(this.objectType);
            } else {
                Class<?> type = this.object.getClass();
                this.objectType = WhiteboxImpl.getUnmockedType(type);
                this.methodInvocationControl = MockRepository.getInstanceMethodInvocationControl(this.object);
            }
            this.method = MockInvocation.findMethodToInvoke(this.methodName, this.sig, this.objectType);
        }
    }
}

