/*
 * Decompiled with CFR 0.152.
 */
package scala.io;

import scala.List;
import scala.List$;
import scala.ScalaObject;
import scala.ScalaObject$class;
import scala.runtime.BoxedByteArray;
import scala.runtime.BoxesRunTime;

public final class UTF8Codec$
implements ScalaObject {
    public static final UTF8Codec$ MODULE$;
    private final int UNI_REPLACEMENT_CHAR;

    static {
        new UTF8Codec$();
    }

    public UTF8Codec$() {
        this.UNI_REPLACEMENT_CHAR = 65533;
        MODULE$ = this;
    }

    public String decode(byte[] src, int from2, int len) {
        char[] cs = new char[len];
        return new String(cs, 0, this.decode(src, 0, cs, 0, len));
    }

    public int decode(byte[] src, int from2, char[] dst, int to, int len) {
        int i = from2;
        int j = to;
        int end = from2 + len;
        while (i < end) {
            int b = src[i] & 0xFF;
            ++i;
            if (b >= 224) {
                b = (b & 0xF) << 12 | (src[i] & 0x3F) << 6;
                b |= src[i + 1] & 0x3F;
                i += 2;
            } else if (b >= 192) {
                b = (b & 0x1F) << 6 | src[i] & 0x3F;
                ++i;
            }
            dst[j] = (char)b;
            ++j;
        }
        return j;
    }

    public byte[] encode(String s) {
        byte[] dst = new byte[s.length() * 3];
        int len = this.encode(s, dst, 0);
        return new BoxedByteArray(dst).subArray(0, len);
    }

    public int encode(String s, byte[] dst, int to) {
        return this.encode(s.toCharArray(), 0, dst, to, s.length());
    }

    public int encode(char[] src, int from2, byte[] dst, int to, int len) {
        int j = to;
        int end = from2 + len;
        for (int i = from2; i < end; ++i) {
            char ch = src[i];
            if (ch < '\u0080') {
                dst[j] = (byte)ch;
                ++j;
                continue;
            }
            if (ch <= '\u03ff') {
                dst[j] = (byte)(0xC0 | ch >> 6);
                dst[j + 1] = (byte)(0x80 | ch & 0x3F);
                j += 2;
                continue;
            }
            dst[j] = (byte)(0xE0 | ch >> 12);
            dst[j + 1] = (byte)(0x80 | ch >> 6 & 0x3F);
            dst[j + 2] = (byte)(0x80 | ch & 0x3F);
            j += 3;
        }
        return j;
    }

    public byte[] encode(int ch1) {
        block11: {
            List firstByteMark;
            int bytesToWrite;
            int byteMark;
            int byteMask;
            int ch;
            block8: {
                block10: {
                    block9: {
                        block7: {
                            ch = ch1;
                            byteMask = 191;
                            byteMark = 128;
                            bytesToWrite = 0;
                            firstByteMark = List$.MODULE$.apply(new BoxedByteArray(new byte[]{(byte)0, (byte)0, (byte)192, (byte)224, (byte)240, (byte)248, (byte)252}));
                            if (ch >= 128) break block7;
                            bytesToWrite = 1;
                            break block8;
                        }
                        if (ch >= 2048) break block9;
                        bytesToWrite = 2;
                        break block8;
                    }
                    if (ch >= 65536) break block10;
                    bytesToWrite = 3;
                    break block8;
                }
                if (ch > 0x10FFFF) break block11;
                bytesToWrite = 4;
            }
            byte[] res = new byte[bytesToWrite];
            int bw = bytesToWrite;
            if (bw >= 4) {
                res[3] = (byte)((ch | byteMark) & byteMask);
                ch >>= 6;
                --bw;
            }
            if (bw >= 3) {
                res[2] = (byte)((ch | byteMark) & byteMask);
                ch >>= 6;
                --bw;
            }
            if (bw >= 2) {
                res[1] = (byte)((ch | byteMark) & byteMask);
                ch >>= 6;
                --bw;
            }
            if (bw >= 1) {
                res[0] = (byte)(ch | BoxesRunTime.unboxToByte(firstByteMark.apply(bytesToWrite)));
            }
            return res;
        }
        return this.encode(this.UNI_REPLACEMENT_CHAR());
    }

    public final int UNI_REPLACEMENT_CHAR() {
        return this.UNI_REPLACEMENT_CHAR;
    }

    public int $tag() {
        return ScalaObject$class.$tag(this);
    }
}

