/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.erlang.support.converter;

import com.ericsson.otp.erlang.OtpErlangAtom;
import com.ericsson.otp.erlang.OtpErlangBinary;
import com.ericsson.otp.erlang.OtpErlangBoolean;
import com.ericsson.otp.erlang.OtpErlangByte;
import com.ericsson.otp.erlang.OtpErlangChar;
import com.ericsson.otp.erlang.OtpErlangDouble;
import com.ericsson.otp.erlang.OtpErlangFloat;
import com.ericsson.otp.erlang.OtpErlangInt;
import com.ericsson.otp.erlang.OtpErlangList;
import com.ericsson.otp.erlang.OtpErlangLong;
import com.ericsson.otp.erlang.OtpErlangObject;
import com.ericsson.otp.erlang.OtpErlangPid;
import com.ericsson.otp.erlang.OtpErlangRangeException;
import com.ericsson.otp.erlang.OtpErlangShort;
import com.ericsson.otp.erlang.OtpErlangString;
import java.util.ArrayList;
import org.springframework.erlang.support.converter.ErlangConversionException;
import org.springframework.erlang.support.converter.ErlangConverter;

public class SimpleErlangConverter
implements ErlangConverter {
    @Override
    public Object fromErlang(OtpErlangObject erlangObject) throws ErlangConversionException {
        return this.convertErlangToBasicType(erlangObject);
    }

    @Override
    public Object fromErlangRpc(String module, String function, OtpErlangObject erlangObject) throws ErlangConversionException {
        return this.fromErlang(erlangObject);
    }

    @Override
    public OtpErlangObject toErlang(Object obj) throws ErlangConversionException {
        if (obj instanceof OtpErlangObject) {
            return (OtpErlangObject)obj;
        }
        if (obj instanceof Object[]) {
            Object[] objectsToConvert = (Object[])obj;
            if (objectsToConvert.length != 0) {
                ArrayList<OtpErlangObject> tempList = new ArrayList<OtpErlangObject>();
                for (Object objectToConvert : objectsToConvert) {
                    OtpErlangObject erlangObject = this.convertBasicTypeToErlang(objectToConvert);
                    tempList.add(erlangObject);
                }
                OtpErlangObject[] ia = new OtpErlangObject[tempList.size()];
                return new OtpErlangList(tempList.toArray(ia));
            }
            return new OtpErlangList();
        }
        return this.convertBasicTypeToErlang(obj);
    }

    protected OtpErlangObject convertBasicTypeToErlang(Object obj) {
        if (obj instanceof byte[]) {
            return new OtpErlangBinary((byte[])obj);
        }
        if (obj instanceof Boolean) {
            return new OtpErlangBoolean(((Boolean)obj).booleanValue());
        }
        if (obj instanceof Byte) {
            return new OtpErlangByte(((Byte)obj).byteValue());
        }
        if (obj instanceof Character) {
            return new OtpErlangChar(((Character)obj).charValue());
        }
        if (obj instanceof Double) {
            return new OtpErlangDouble(((Double)obj).doubleValue());
        }
        if (obj instanceof Float) {
            return new OtpErlangFloat(((Float)obj).floatValue());
        }
        if (obj instanceof Integer) {
            return new OtpErlangInt(((Integer)obj).intValue());
        }
        if (obj instanceof Long) {
            return new OtpErlangLong(((Long)obj).longValue());
        }
        if (obj instanceof Short) {
            return new OtpErlangShort(((Short)obj).shortValue());
        }
        if (obj instanceof String) {
            return new OtpErlangString((String)obj);
        }
        throw new ErlangConversionException("Could not convert Java object of type [" + obj.getClass() + "] to an Erlang data type.");
    }

    protected Object convertErlangToBasicType(OtpErlangObject erlangObject) {
        try {
            if (erlangObject instanceof OtpErlangBinary) {
                return ((OtpErlangBinary)erlangObject).binaryValue();
            }
            if (erlangObject instanceof OtpErlangAtom) {
                return ((OtpErlangAtom)erlangObject).atomValue();
            }
            if (erlangObject instanceof OtpErlangBinary) {
                return ((OtpErlangBinary)erlangObject).binaryValue();
            }
            if (erlangObject instanceof OtpErlangBoolean) {
                return SimpleErlangConverter.extractBoolean(erlangObject);
            }
            if (erlangObject instanceof OtpErlangByte) {
                return ((OtpErlangByte)erlangObject).byteValue();
            }
            if (erlangObject instanceof OtpErlangChar) {
                return Character.valueOf(((OtpErlangChar)erlangObject).charValue());
            }
            if (erlangObject instanceof OtpErlangDouble) {
                return ((OtpErlangDouble)erlangObject).doubleValue();
            }
            if (erlangObject instanceof OtpErlangFloat) {
                return Float.valueOf(((OtpErlangFloat)erlangObject).floatValue());
            }
            if (erlangObject instanceof OtpErlangInt) {
                return ((OtpErlangInt)erlangObject).intValue();
            }
            if (erlangObject instanceof OtpErlangLong) {
                return ((OtpErlangLong)erlangObject).longValue();
            }
            if (erlangObject instanceof OtpErlangShort) {
                return ((OtpErlangShort)erlangObject).shortValue();
            }
            if (erlangObject instanceof OtpErlangString) {
                return ((OtpErlangString)erlangObject).stringValue();
            }
            if (erlangObject instanceof OtpErlangPid) {
                return ((OtpErlangPid)erlangObject).toString();
            }
            throw new ErlangConversionException("Could not convert Erlang object [" + erlangObject.getClass() + "] to Java type.");
        }
        catch (OtpErlangRangeException e) {
            throw new ErlangConversionException("Could not convert Erlang object [" + erlangObject.getClass() + "] to Java type.", e);
        }
    }

    public static boolean extractBoolean(OtpErlangObject erlangObject) {
        return ((OtpErlangBoolean)erlangObject).booleanValue();
    }

    public static String extractPid(OtpErlangObject value) {
        return ((OtpErlangPid)value).toString();
    }

    public static long extractLong(OtpErlangObject value) {
        return ((OtpErlangLong)value).longValue();
    }
}

