/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.properties.bind;

import java.lang.annotation.Annotation;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.core.ResolvableType;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;

final class ResolvableTypeDescriptor
extends TypeDescriptor {
    private ResolvableTypeDescriptor(ResolvableType resolvableType, Annotation[] annotations) {
        super(resolvableType, null, annotations);
    }

    public boolean canConvert(ConversionService conversionService, Object source) {
        TypeDescriptor sourceType = TypeDescriptor.forObject((Object)source);
        return conversionService.canConvert(sourceType, (TypeDescriptor)this);
    }

    public <T> T convert(ConversionService conversionService, Object value) {
        if (value == null) {
            return null;
        }
        TypeDescriptor sourceType = TypeDescriptor.forObject((Object)value);
        return (T)conversionService.convert(value, sourceType, (TypeDescriptor)this);
    }

    public static ResolvableTypeDescriptor forBindable(Bindable<?> bindable) {
        return ResolvableTypeDescriptor.forType(bindable.getType(), bindable.getAnnotations());
    }

    public static ResolvableTypeDescriptor forType(ResolvableType type, Annotation ... annotations) {
        return new ResolvableTypeDescriptor(type, annotations);
    }
}

