/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.properties.bind.convert;

import java.util.function.Function;
import org.springframework.boot.context.properties.bind.convert.InetAddressToStringConverter;
import org.springframework.boot.context.properties.bind.convert.PropertyEditorConverter;
import org.springframework.boot.context.properties.bind.convert.StringToCharArrayConverter;
import org.springframework.boot.context.properties.bind.convert.StringToEnumConverterFactory;
import org.springframework.boot.context.properties.bind.convert.StringToInetAddressConverter;
import org.springframework.core.convert.ConversionException;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.ConverterNotFoundException;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.ConverterFactory;
import org.springframework.core.convert.converter.ConverterRegistry;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.format.FormatterRegistry;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.format.datetime.DateFormatter;
import org.springframework.format.datetime.DateFormatterRegistrar;
import org.springframework.format.support.DefaultFormattingConversionService;

public class BinderConversionService
implements ConversionService {
    private final ConversionService conversionService;
    private final ConversionService additionalConversionService;

    public BinderConversionService(ConversionService conversionService) {
        this.conversionService = conversionService != null ? conversionService : new DefaultFormattingConversionService();
        this.additionalConversionService = BinderConversionService.createAdditionalConversionService();
    }

    public boolean canConvert(Class<?> sourceType, Class<?> targetType) {
        return this.conversionService != null && this.conversionService.canConvert(sourceType, targetType) || this.additionalConversionService.canConvert(sourceType, targetType);
    }

    public boolean canConvert(TypeDescriptor sourceType, TypeDescriptor targetType) {
        return this.conversionService != null && this.conversionService.canConvert(sourceType, targetType) || this.additionalConversionService.canConvert(sourceType, targetType);
    }

    public <T> T convert(Object source, Class<T> targetType) {
        return (T)this.callConversionService(c -> c.convert(source, targetType));
    }

    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        return this.callConversionService(c -> c.convert(source, sourceType, targetType));
    }

    private <T> T callConversionService(Function<ConversionService, T> call) {
        if (this.conversionService == null) {
            return this.callAdditionalConversionService(call, null);
        }
        try {
            return call.apply(this.conversionService);
        }
        catch (ConversionException ex) {
            return this.callAdditionalConversionService(call, (RuntimeException)((Object)ex));
        }
    }

    private <T> T callAdditionalConversionService(Function<ConversionService, T> call, RuntimeException cause) {
        try {
            return call.apply(this.additionalConversionService);
        }
        catch (ConverterNotFoundException ex) {
            throw cause != null ? cause : ex;
        }
    }

    private static ConversionService createAdditionalConversionService() {
        DefaultFormattingConversionService service = new DefaultFormattingConversionService();
        DefaultConversionService.addCollectionConverters((ConverterRegistry)service);
        service.addConverterFactory((ConverterFactory)new StringToEnumConverterFactory());
        service.addConverter((Converter)new StringToCharArrayConverter());
        service.addConverter((Converter)new StringToInetAddressConverter());
        service.addConverter((Converter)new InetAddressToStringConverter());
        service.addConverter((GenericConverter)new PropertyEditorConverter());
        DateFormatterRegistrar registrar = new DateFormatterRegistrar();
        DateFormatter formatter = new DateFormatter();
        formatter.setIso(DateTimeFormat.ISO.DATE_TIME);
        registrar.setFormatter(formatter);
        registrar.registerFormatters((FormatterRegistry)service);
        return service;
    }
}

