/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.web.embedded.netty;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.springframework.boot.web.embedded.netty.NettyServerCustomizer;
import org.springframework.boot.web.embedded.netty.NettyWebServer;
import org.springframework.boot.web.embedded.netty.SslServerCustomizer;
import org.springframework.boot.web.reactive.server.AbstractReactiveWebServerFactory;
import org.springframework.boot.web.server.WebServer;
import org.springframework.http.server.reactive.HttpHandler;
import org.springframework.http.server.reactive.ReactorHttpHandlerAdapter;
import org.springframework.util.Assert;
import reactor.ipc.netty.http.server.HttpServer;
import reactor.ipc.netty.http.server.HttpServerOptions;

public class NettyReactiveWebServerFactory
extends AbstractReactiveWebServerFactory {
    private List<NettyServerCustomizer> nettyServerCustomizers = new ArrayList<NettyServerCustomizer>();

    public NettyReactiveWebServerFactory() {
    }

    public NettyReactiveWebServerFactory(int port) {
        super(port);
    }

    @Override
    public WebServer getWebServer(HttpHandler httpHandler) {
        HttpServer server = this.createHttpServer();
        ReactorHttpHandlerAdapter handlerAdapter = new ReactorHttpHandlerAdapter(httpHandler);
        return new NettyWebServer(server, handlerAdapter);
    }

    public Collection<NettyServerCustomizer> getNettyServerCustomizers() {
        return this.nettyServerCustomizers;
    }

    public void setNettyServerCustomizers(Collection<? extends NettyServerCustomizer> nettyServerCustomizers) {
        Assert.notNull(nettyServerCustomizers, (String)"NettyServerCustomizers must not be null");
        this.nettyServerCustomizers = new ArrayList<NettyServerCustomizer>(nettyServerCustomizers);
    }

    public void addContextCustomizers(NettyServerCustomizer ... nettyServerCustomizer) {
        Assert.notNull((Object)nettyServerCustomizer, (String)"NettyWebServerCustomizer must not be null");
        this.nettyServerCustomizers.addAll(Arrays.asList(nettyServerCustomizer));
    }

    private HttpServer createHttpServer() {
        return HttpServer.builder().options(options -> {
            options.listenAddress((SocketAddress)this.getListenAddress());
            if (this.getSsl() != null && this.getSsl().isEnabled()) {
                SslServerCustomizer sslServerCustomizer = new SslServerCustomizer(this.getSsl(), this.getSslStoreProvider());
                sslServerCustomizer.customize((HttpServerOptions.Builder)options);
            }
            this.applyCustomizers((HttpServerOptions.Builder)options);
        }).build();
    }

    private InetSocketAddress getListenAddress() {
        if (this.getAddress() != null) {
            return new InetSocketAddress(this.getAddress().getHostAddress(), this.getPort());
        }
        return new InetSocketAddress(this.getPort());
    }

    private void applyCustomizers(HttpServerOptions.Builder options) {
        this.nettyServerCustomizers.forEach(customizer -> customizer.customize(options));
    }
}

