/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.aggregation;

import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.data.mongodb.core.aggregation.AbstractAggregationExpression;
import org.springframework.data.mongodb.core.aggregation.AggregationExpression;
import org.springframework.data.mongodb.core.aggregation.Fields;
import org.springframework.util.Assert;

public class DateOperators {
    public static DateOperatorFactory dateOf(String fieldReference) {
        Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null!");
        return new DateOperatorFactory(fieldReference);
    }

    public static DateOperatorFactory dateOf(AggregationExpression expression) {
        Assert.notNull((Object)expression, (String)"Expression must not be null!");
        return new DateOperatorFactory(expression);
    }

    public static class IsoWeekYear
    extends AbstractAggregationExpression {
        private IsoWeekYear(Object value) {
            super(value);
        }

        @Override
        protected String getMongoMethod() {
            return "$isoWeekYear";
        }

        public static IsoWeekYear isoWeekYearOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null!");
            return new IsoWeekYear(Fields.field(fieldReference));
        }

        public static IsoWeekYear isoWeekYearOf(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null!");
            return new IsoWeekYear(expression);
        }
    }

    public static class IsoWeek
    extends AbstractAggregationExpression {
        private IsoWeek(Object value) {
            super(value);
        }

        @Override
        protected String getMongoMethod() {
            return "$isoWeek";
        }

        public static IsoWeek isoWeekOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null!");
            return new IsoWeek(Fields.field(fieldReference));
        }

        public static IsoWeek isoWeekOf(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null!");
            return new IsoWeek(expression);
        }
    }

    public static class IsoDayOfWeek
    extends AbstractAggregationExpression {
        private IsoDayOfWeek(Object value) {
            super(value);
        }

        @Override
        protected String getMongoMethod() {
            return "$isoDayOfWeek";
        }

        public static IsoDayOfWeek isoDayOfWeek(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null!");
            return new IsoDayOfWeek(Fields.field(fieldReference));
        }

        public static IsoDayOfWeek isoDayOfWeek(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null!");
            return new IsoDayOfWeek(expression);
        }
    }

    public static class DateToString
    extends AbstractAggregationExpression {
        private DateToString(Object value) {
            super(value);
        }

        @Override
        protected String getMongoMethod() {
            return "$dateToString";
        }

        public static FormatBuilder dateOf(final String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null!");
            return new FormatBuilder(){

                @Override
                public DateToString toString(String format) {
                    Assert.notNull((Object)format, (String)"Format must not be null!");
                    return new DateToString(DateToString.argumentMap(Fields.field(fieldReference), format));
                }
            };
        }

        public static FormatBuilder dateOf(final AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null!");
            return new FormatBuilder(){

                @Override
                public DateToString toString(String format) {
                    Assert.notNull((Object)format, (String)"Format must not be null!");
                    return new DateToString(DateToString.argumentMap(expression, format));
                }
            };
        }

        private static Map<String, Object> argumentMap(Object date, String format) {
            LinkedHashMap<String, Object> args = new LinkedHashMap<String, Object>(2);
            args.put("format", format);
            args.put("date", date);
            return args;
        }

        public static interface FormatBuilder {
            public DateToString toString(String var1);
        }
    }

    public static class Millisecond
    extends AbstractAggregationExpression {
        private Millisecond(Object value) {
            super(value);
        }

        @Override
        protected String getMongoMethod() {
            return "$millisecond";
        }

        public static Millisecond millisecondOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null!");
            return new Millisecond(Fields.field(fieldReference));
        }

        public static Millisecond millisecondOf(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null!");
            return new Millisecond(expression);
        }
    }

    public static class Second
    extends AbstractAggregationExpression {
        private Second(Object value) {
            super(value);
        }

        @Override
        protected String getMongoMethod() {
            return "$second";
        }

        public static Second secondOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null!");
            return new Second(Fields.field(fieldReference));
        }

        public static Second secondOf(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null!");
            return new Second(expression);
        }
    }

    public static class Minute
    extends AbstractAggregationExpression {
        private Minute(Object value) {
            super(value);
        }

        @Override
        protected String getMongoMethod() {
            return "$minute";
        }

        public static Minute minuteOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null!");
            return new Minute(Fields.field(fieldReference));
        }

        public static Minute minuteOf(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null!");
            return new Minute(expression);
        }
    }

    public static class Hour
    extends AbstractAggregationExpression {
        private Hour(Object value) {
            super(value);
        }

        @Override
        protected String getMongoMethod() {
            return "$hour";
        }

        public static Hour hourOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null!");
            return new Hour(Fields.field(fieldReference));
        }

        public static Hour hourOf(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null!");
            return new Hour(expression);
        }
    }

    public static class Week
    extends AbstractAggregationExpression {
        private Week(Object value) {
            super(value);
        }

        @Override
        protected String getMongoMethod() {
            return "$week";
        }

        public static Week weekOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null!");
            return new Week(Fields.field(fieldReference));
        }

        public static Week weekOf(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null!");
            return new Week(expression);
        }
    }

    public static class Month
    extends AbstractAggregationExpression {
        private Month(Object value) {
            super(value);
        }

        @Override
        protected String getMongoMethod() {
            return "$month";
        }

        public static Month monthOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null!");
            return new Month(Fields.field(fieldReference));
        }

        public static Month monthOf(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null!");
            return new Month(expression);
        }
    }

    public static class Year
    extends AbstractAggregationExpression {
        private Year(Object value) {
            super(value);
        }

        @Override
        protected String getMongoMethod() {
            return "$year";
        }

        public static Year yearOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null!");
            return new Year(Fields.field(fieldReference));
        }

        public static Year yearOf(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null!");
            return new Year(expression);
        }
    }

    public static class DayOfWeek
    extends AbstractAggregationExpression {
        private DayOfWeek(Object value) {
            super(value);
        }

        @Override
        protected String getMongoMethod() {
            return "$dayOfWeek";
        }

        public static DayOfWeek dayOfWeek(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null!");
            return new DayOfWeek(Fields.field(fieldReference));
        }

        public static DayOfWeek dayOfWeek(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null!");
            return new DayOfWeek(expression);
        }
    }

    public static class DayOfMonth
    extends AbstractAggregationExpression {
        private DayOfMonth(Object value) {
            super(value);
        }

        @Override
        protected String getMongoMethod() {
            return "$dayOfMonth";
        }

        public static DayOfMonth dayOfMonth(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null!");
            return new DayOfMonth(Fields.field(fieldReference));
        }

        public static DayOfMonth dayOfMonth(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null!");
            return new DayOfMonth(expression);
        }
    }

    public static class DayOfYear
    extends AbstractAggregationExpression {
        private DayOfYear(Object value) {
            super(value);
        }

        @Override
        protected String getMongoMethod() {
            return "$dayOfYear";
        }

        public static DayOfYear dayOfYear(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null!");
            return new DayOfYear(Fields.field(fieldReference));
        }

        public static DayOfYear dayOfYear(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null!");
            return new DayOfYear(expression);
        }
    }

    public static class DateOperatorFactory {
        private final String fieldReference;
        private final AggregationExpression expression;

        public DateOperatorFactory(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null!");
            this.fieldReference = fieldReference;
            this.expression = null;
        }

        public DateOperatorFactory(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null!");
            this.fieldReference = null;
            this.expression = expression;
        }

        public DayOfYear dayOfYear() {
            return this.usesFieldRef() ? DayOfYear.dayOfYear(this.fieldReference) : DayOfYear.dayOfYear(this.expression);
        }

        public DayOfMonth dayOfMonth() {
            return this.usesFieldRef() ? DayOfMonth.dayOfMonth(this.fieldReference) : DayOfMonth.dayOfMonth(this.expression);
        }

        public DayOfWeek dayOfWeek() {
            return this.usesFieldRef() ? DayOfWeek.dayOfWeek(this.fieldReference) : DayOfWeek.dayOfWeek(this.expression);
        }

        public Year year() {
            return this.usesFieldRef() ? Year.yearOf(this.fieldReference) : Year.yearOf(this.expression);
        }

        public Month month() {
            return this.usesFieldRef() ? Month.monthOf(this.fieldReference) : Month.monthOf(this.expression);
        }

        public Week week() {
            return this.usesFieldRef() ? Week.weekOf(this.fieldReference) : Week.weekOf(this.expression);
        }

        public Hour hour() {
            return this.usesFieldRef() ? Hour.hourOf(this.fieldReference) : Hour.hourOf(this.expression);
        }

        public Minute minute() {
            return this.usesFieldRef() ? Minute.minuteOf(this.fieldReference) : Minute.minuteOf(this.expression);
        }

        public Second second() {
            return this.usesFieldRef() ? Second.secondOf(this.fieldReference) : Second.secondOf(this.expression);
        }

        public Millisecond millisecond() {
            return this.usesFieldRef() ? Millisecond.millisecondOf(this.fieldReference) : Millisecond.millisecondOf(this.expression);
        }

        public DateToString toString(String format) {
            return (this.usesFieldRef() ? DateToString.dateOf(this.fieldReference) : DateToString.dateOf(this.expression)).toString(format);
        }

        public IsoDayOfWeek isoDayOfWeek() {
            return this.usesFieldRef() ? IsoDayOfWeek.isoDayOfWeek(this.fieldReference) : IsoDayOfWeek.isoDayOfWeek(this.expression);
        }

        public IsoWeek isoWeek() {
            return this.usesFieldRef() ? IsoWeek.isoWeekOf(this.fieldReference) : IsoWeek.isoWeekOf(this.expression);
        }

        public IsoWeekYear isoWeekYear() {
            return this.usesFieldRef() ? IsoWeekYear.isoWeekYearOf(this.fieldReference) : IsoWeekYear.isoWeekYearOf(this.expression);
        }

        private boolean usesFieldRef() {
            return this.fieldReference != null;
        }
    }
}

