/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.repository.support;

import java.lang.reflect.Method;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.support.Repositories;
import org.springframework.data.rest.config.RepositoryRestConfiguration;
import org.springframework.data.rest.config.ResourceMapping;
import org.springframework.data.rest.repository.invoke.RepositoryMethod;
import org.springframework.data.rest.repository.support.ResourceMappingUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public abstract class RepositoryInformationSupport {
    protected Repositories repositories;
    protected RepositoryRestConfiguration config;
    protected MultiValueMap<Class<?>, RepositoryMethod> repositoryMethods = new LinkedMultiValueMap();

    public Repositories getRepositories() {
        return this.repositories;
    }

    @Autowired
    public void setRepositories(Repositories repositories) {
        this.repositories = repositories;
        for (Class domainType : repositories) {
            final RepositoryInformation repoInfo = repositories.getRepositoryInformationFor(domainType);
            ReflectionUtils.doWithMethods((Class)repoInfo.getRepositoryInterface(), (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

                public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
                    RepositoryInformationSupport.this.repositoryMethods.add((Object)repoInfo.getRepositoryInterface(), (Object)new RepositoryMethod(method));
                }
            });
        }
    }

    public RepositoryRestConfiguration getConfig() {
        return this.config;
    }

    @Autowired
    public void setConfig(RepositoryRestConfiguration config) {
        this.config = config;
    }

    protected RepositoryInformation findRepositoryInfoFor(String pathSegment) {
        if (!StringUtils.hasText((String)pathSegment)) {
            return null;
        }
        for (Class domainType : this.repositories) {
            RepositoryInformation repoInfo = this.findRepositoryInfoFor(domainType);
            ResourceMapping mapping = ResourceMappingUtils.getResourceMapping(this.config, repoInfo);
            if (!pathSegment.equals(mapping.getPath()) || !mapping.isExported()) continue;
            return repoInfo;
        }
        return null;
    }

    protected RepositoryInformation findRepositoryInfoFor(Class<?> domainType) {
        PersistentEntity entity = this.repositories.getPersistentEntity(domainType);
        if (null != entity) {
            return this.repositories.getRepositoryInformationFor(domainType);
        }
        return null;
    }
}

