/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.BeanFactory;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=2, d1={"\u0000(\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u001e\u0010\u0000\u001a\u0002H\u0001\"\n\b\u0000\u0010\u0001\u0018\u0001*\u00020\u0002*\u00020\u0003H\u0086\b\u00a2\u0006\u0002\u0010\u0004\u001a2\u0010\u0000\u001a\u0002H\u0001\"\n\b\u0000\u0010\u0001\u0018\u0001*\u00020\u0002*\u00020\u00032\u0012\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u0006\"\u00020\u0002H\u0086\b\u00a2\u0006\u0002\u0010\u0007\u001a&\u0010\u0000\u001a\u0002H\u0001\"\n\b\u0000\u0010\u0001\u0018\u0001*\u00020\u0002*\u00020\u00032\u0006\u0010\b\u001a\u00020\tH\u0087\b\u00a2\u0006\u0002\u0010\n\u001a/\u0010\u0000\u001a\u0002H\u0001\"\b\b\u0000\u0010\u0001*\u00020\u0002*\u00020\u00032\u0006\u0010\b\u001a\u00020\t2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\u00010\f\u00a2\u0006\u0002\u0010\r\u001a'\u0010\u0000\u001a\u0002H\u0001\"\b\b\u0000\u0010\u0001*\u00020\u0002*\u00020\u00032\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\u00010\f\u00a2\u0006\u0002\u0010\u000e\u001a;\u0010\u0000\u001a\u0002H\u0001\"\b\b\u0000\u0010\u0001*\u00020\u0002*\u00020\u00032\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\u00010\f2\u0012\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u0006\"\u00020\u0002\u00a2\u0006\u0002\u0010\u000f\u00a8\u0006\u0010"}, d2={"getBean", "T", "", "Lorg/springframework/beans/factory/BeanFactory;", "(Lorg/springframework/beans/factory/BeanFactory;)Ljava/lang/Object;", "args", "", "(Lorg/springframework/beans/factory/BeanFactory;[Ljava/lang/Object;)Ljava/lang/Object;", "name", "", "(Lorg/springframework/beans/factory/BeanFactory;Ljava/lang/String;)Ljava/lang/Object;", "requiredType", "Lkotlin/reflect/KClass;", "(Lorg/springframework/beans/factory/BeanFactory;Ljava/lang/String;Lkotlin/reflect/KClass;)Ljava/lang/Object;", "(Lorg/springframework/beans/factory/BeanFactory;Lkotlin/reflect/KClass;)Ljava/lang/Object;", "(Lorg/springframework/beans/factory/BeanFactory;Lkotlin/reflect/KClass;[Ljava/lang/Object;)Ljava/lang/Object;", "spring-beans_main"})
public final class BeanFactoryExtensionsKt {
    @NotNull
    public static final <T> T getBean(@NotNull BeanFactory $receiver, @NotNull KClass<T> requiredType) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(requiredType, (String)"requiredType");
        Object t = $receiver.getBean(JvmClassMappingKt.getJavaClass(requiredType));
        Intrinsics.checkExpressionValueIsNotNull(t, (String)"getBean(requiredType.java)");
        return t;
    }

    private static final <T> T getBean(@NotNull BeanFactory $receiver) {
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        Object object = $receiver.getBean(Object.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"getBean(T::class.java)");
        return (T)object;
    }

    @NotNull
    public static final <T> T getBean(@NotNull BeanFactory $receiver, @NotNull String name, @NotNull KClass<T> requiredType) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull(requiredType, (String)"requiredType");
        Object t = $receiver.getBean(name, JvmClassMappingKt.getJavaClass(requiredType));
        Intrinsics.checkExpressionValueIsNotNull(t, (String)"getBean(name, requiredType.java)");
        return t;
    }

    private static final <T> T getBean(@NotNull BeanFactory $receiver, String name) {
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        Object object = $receiver.getBean(name, Object.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"getBean(name, T::class.java)");
        return (T)object;
    }

    @NotNull
    public static final <T> T getBean(@NotNull BeanFactory $receiver, @NotNull KClass<T> requiredType, Object ... args) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(requiredType, (String)"requiredType");
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        Object t = $receiver.getBean(JvmClassMappingKt.getJavaClass(requiredType), Arrays.copyOf(args, args.length));
        Intrinsics.checkExpressionValueIsNotNull(t, (String)"getBean(requiredType.java, *args)");
        return t;
    }

    private static final <T> T getBean(@NotNull BeanFactory $receiver, Object ... args) {
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        Object object = $receiver.getBean(Object.class, Arrays.copyOf(args, args.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"getBean(T::class.java, *args)");
        return (T)object;
    }
}

