/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.server.request;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletContext;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.mock.web.MockMultipartHttpServletRequest;
import org.springframework.test.web.server.request.MockHttpServletRequestBuilder;
import org.springframework.web.multipart.MultipartFile;

public class MockMultipartHttpServletRequestBuilder
extends MockHttpServletRequestBuilder {
    private final List<MockMultipartFile> files = new ArrayList<MockMultipartFile>();

    MockMultipartHttpServletRequestBuilder(URI uri) {
        super(uri, HttpMethod.POST);
        super.contentType(MediaType.MULTIPART_FORM_DATA);
    }

    public MockMultipartHttpServletRequestBuilder file(String name, byte[] content) {
        this.files.add(new MockMultipartFile(name, content));
        return this;
    }

    public MockMultipartHttpServletRequestBuilder file(MockMultipartFile file) {
        this.files.add(file);
        return this;
    }

    public Object merge(Object parent) {
        if (parent == null) {
            return this;
        }
        if (!(parent instanceof MockMultipartHttpServletRequestBuilder)) {
            throw new IllegalArgumentException("Cannot merge with [" + parent.getClass().getName() + "]");
        }
        super.merge(parent);
        MockMultipartHttpServletRequestBuilder parentBuilder = (MockMultipartHttpServletRequestBuilder)parent;
        this.files.addAll(parentBuilder.files);
        return this;
    }

    protected final MockHttpServletRequest createServletRequest(ServletContext servletContext) {
        MockMultipartHttpServletRequest request = new MockMultipartHttpServletRequest();
        for (MockMultipartFile file : this.files) {
            request.addFile((MultipartFile)file);
        }
        return request;
    }
}

