/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.server.request;

import java.net.URI;
import org.springframework.http.HttpMethod;
import org.springframework.test.web.server.request.MockHttpServletRequestBuilder;
import org.springframework.test.web.server.request.MockMultipartHttpServletRequestBuilder;
import org.springframework.web.util.UriTemplate;

public abstract class MockMvcRequestBuilders {
    private MockMvcRequestBuilders() {
    }

    public static MockHttpServletRequestBuilder get(String urlTemplate, Object ... urlVariables) {
        return MockMvcRequestBuilders.request(HttpMethod.GET, urlTemplate, urlVariables);
    }

    public static MockHttpServletRequestBuilder post(String urlTemplate, Object ... urlVariables) {
        return MockMvcRequestBuilders.request(HttpMethod.POST, urlTemplate, urlVariables);
    }

    public static MockHttpServletRequestBuilder put(String urlTemplate, Object ... urlVariables) {
        return MockMvcRequestBuilders.request(HttpMethod.PUT, urlTemplate, urlVariables);
    }

    public static MockHttpServletRequestBuilder delete(String urlTemplate, Object ... urlVariables) {
        return MockMvcRequestBuilders.request(HttpMethod.DELETE, urlTemplate, urlVariables);
    }

    public static MockMultipartHttpServletRequestBuilder fileUpload(String urlTemplate, Object ... urlVariables) {
        URI url = MockMvcRequestBuilders.expandUrl(urlTemplate, urlVariables);
        return new MockMultipartHttpServletRequestBuilder(url);
    }

    private static MockHttpServletRequestBuilder request(HttpMethod httpMethod, String urlTemplate, Object ... urlVariables) {
        URI url = MockMvcRequestBuilders.expandUrl(urlTemplate, urlVariables);
        return new MockHttpServletRequestBuilder(url, httpMethod);
    }

    private static URI expandUrl(String urlTemplate, Object[] urlVariables) {
        UriTemplate uriTemplate = new UriTemplate(urlTemplate);
        return uriTemplate.expand(urlVariables);
    }
}

