/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.server.result;

import java.util.Map;
import javax.xml.xpath.XPathExpressionException;
import org.hamcrest.Matcher;
import org.springframework.test.web.AssertionErrors;
import org.springframework.test.web.server.MvcResult;
import org.springframework.test.web.server.ResultMatcher;
import org.springframework.test.web.server.result.ContentResultMatchers;
import org.springframework.test.web.server.result.CookieResultMatchers;
import org.springframework.test.web.server.result.FlashAttributeResultMatchers;
import org.springframework.test.web.server.result.HandlerResultMatchers;
import org.springframework.test.web.server.result.HeaderResultMatchers;
import org.springframework.test.web.server.result.JsonPathResultMatchers;
import org.springframework.test.web.server.result.ModelResultMatchers;
import org.springframework.test.web.server.result.RequestResultMatchers;
import org.springframework.test.web.server.result.StatusResultMatchers;
import org.springframework.test.web.server.result.ViewResultMatchers;
import org.springframework.test.web.server.result.XpathResultMatchers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MockMvcResultMatchers {
    private MockMvcResultMatchers() {
    }

    public static RequestResultMatchers request() {
        return new RequestResultMatchers();
    }

    public static HandlerResultMatchers handler() {
        return new HandlerResultMatchers();
    }

    public static ModelResultMatchers model() {
        return new ModelResultMatchers();
    }

    public static ViewResultMatchers view() {
        return new ViewResultMatchers();
    }

    public static FlashAttributeResultMatchers flash() {
        return new FlashAttributeResultMatchers();
    }

    public static ResultMatcher forwardedUrl(final String expectedUrl) {
        return new ResultMatcher(){

            public void match(MvcResult result) {
                AssertionErrors.assertEquals("Forwarded URL", expectedUrl, result.getResponse().getForwardedUrl());
            }
        };
    }

    public static ResultMatcher redirectedUrl(final String expectedUrl) {
        return new ResultMatcher(){

            public void match(MvcResult result) {
                AssertionErrors.assertEquals("Redirected URL", expectedUrl, result.getResponse().getRedirectedUrl());
            }
        };
    }

    public static StatusResultMatchers status() {
        return new StatusResultMatchers();
    }

    public static HeaderResultMatchers header() {
        return new HeaderResultMatchers();
    }

    public static ContentResultMatchers content() {
        return new ContentResultMatchers();
    }

    public static JsonPathResultMatchers jsonPath(String expression, Object ... args) {
        return new JsonPathResultMatchers(expression, args);
    }

    public static <T> ResultMatcher jsonPath(String expression, Matcher<T> matcher) {
        return new JsonPathResultMatchers(expression, new Object[0]).value(matcher);
    }

    public static XpathResultMatchers xpath(String expression, Object ... args) throws XPathExpressionException {
        return new XpathResultMatchers(expression, null, args);
    }

    public static XpathResultMatchers xpath(String expression, Map<String, String> namespaces, Object ... args) throws XPathExpressionException {
        return new XpathResultMatchers(expression, namespaces, args);
    }

    public static CookieResultMatchers cookie() {
        return new CookieResultMatchers();
    }
}

