/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.agent.repkg.de.schlichtherle.io;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

final class CountingOutputStream
extends FilterOutputStream {
    private static volatile long total;
    private static volatile boolean reset;

    CountingOutputStream(OutputStream out) {
        super(out);
        CountingOutputStream.init();
    }

    static long getTotal() {
        return total;
    }

    static void init() {
        if (reset) {
            reset = false;
            total = 0L;
        }
    }

    static void resetOnInit() {
        reset = true;
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
        ++total;
    }

    @Override
    public void write(byte[] b) throws IOException {
        int len = b.length;
        this.out.write(b, 0, len);
        total += (long)len;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
        total += (long)len;
    }
}

