/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.agent.repkg.de.schlichtherle.io;

import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.terracotta.agent.repkg.de.schlichtherle.io.ArchiveController;
import org.terracotta.agent.repkg.de.schlichtherle.io.File;

public class FileInputStream
extends FilterInputStream {
    public FileInputStream(String name) throws FileNotFoundException {
        super(FileInputStream.createInputStream(File.getDefaultArchiveDetector().createFile(name)));
    }

    public FileInputStream(java.io.File file) throws FileNotFoundException {
        super(FileInputStream.createInputStream(file));
    }

    public FileInputStream(FileDescriptor fd) {
        super(new java.io.FileInputStream(fd));
    }

    private static InputStream createInputStream(java.io.File file) throws FileNotFoundException {
        try {
            if (file instanceof File) {
                File smartFile = (File)file;
                smartFile.ensureNotVirtualRoot("cannot read");
                File archive = smartFile.getEnclArchive();
                String entryName = smartFile.getEnclEntryName();
                assert (archive != null == (entryName != null));
                if (archive != null) {
                    return archive.getArchiveController().createInputStream(entryName);
                }
            }
        }
        catch (ArchiveController.RfsEntryFalsePositiveException rfsEntryFalsePositiveException) {
            // empty catch block
        }
        return new java.io.FileInputStream(file);
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.in.read(b, 0, b.length);
    }
}

