/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.agent.repkg.de.schlichtherle.io.util;

import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import org.terracotta.agent.repkg.de.schlichtherle.util.CanonicalStringSet;

public final class SuffixSet
extends CanonicalStringSet {
    private static final char SEPARATOR = '|';
    private static final char PREFIX = '.';

    public SuffixSet() {
        super('|');
    }

    public SuffixSet(String list) {
        super('|');
        if (list != null) {
            super.addAll(list);
        }
    }

    public SuffixSet(Collection c) {
        super('|');
        if (c != null) {
            super.addAll(c);
        }
    }

    @Override
    protected String canonicalize(String suffix) {
        assert (suffix != null);
        assert (suffix.indexOf(124) < 0) : "separator in suffix is illegal";
        if (suffix.length() > 0 && suffix.charAt(0) == '.') {
            suffix = suffix.substring(1);
        }
        return suffix.length() > 0 ? suffix.toLowerCase(Locale.ENGLISH) : null;
    }

    public String toRegex() {
        Iterator i = this.iterator();
        if (i.hasNext()) {
            StringBuffer sb = new StringBuffer(".*\\.(?i)(");
            int c = 0;
            do {
                String suffix = (String)i.next();
                if (c++ > 0) {
                    sb.append('|');
                }
                sb.append("\\Q");
                sb.append(suffix);
                sb.append("\\E");
            } while (i.hasNext());
            assert (c > 0);
            sb.append(")[\\" + File.separatorChar + "/]*");
            return sb.toString();
        }
        return "\\00";
    }
}

