/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.jwicket.demo;

import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.wicketstuff.jwicket.demo.DraggableAndDroppableElement;
import org.wicketstuff.jwicket.demo.GenericPanel;
import org.wicketstuff.jwicket.tooltip.WTooltip;
import org.wicketstuff.jwicket.ui.dragdrop.DraggableBehavior;
import org.wicketstuff.jwicket.ui.dragdrop.DraggablesAcceptedByDroppable;
import org.wicketstuff.jwicket.ui.dragdrop.DroppableBehavior;
import org.wicketstuff.jwicket.ui.effect.Pulsate;

public class DraggableAndDroppableElement
extends GenericPanel<String> {
    private static final long serialVersionUID = 1L;
    protected final Label l;
    private DraggableAndDroppableBox draggable;
    private final DraggableBehavior dragger = new DraggableBehavior();
    private final DroppableBehavior dropper;
    private final Pulsate effect;

    public DraggableAndDroppableElement(String id) {
        this(id, (IModel)new Model((Serializable)((Object)"Drag me!")), null);
    }

    public DraggableAndDroppableElement(String id, IModel<String> model, DraggablesAcceptedByDroppable accepted) {
        super(id, model);
        this.dragger.setRevert(DraggableBehavior.DragRevertMode.ALWAYS);
        this.dragger.setDistance(20);
        this.dragger.setWantOnDragStartNotification(true);
        this.dragger.setOpacity(0.99);
        this.dragger.setWantOnDragStopNotification(true);
        this.dragger.setName("one");
        this.dropper = new DroppableBehavior();
        this.dropper.setHoverClass("hoverClass");
        this.dropper.setActiveClass("activeClass");
        this.dropper.setTolerance(DroppableBehavior.DropTolerance.TOUCH);
        if (accepted != null) {
            this.dropper.setDraggablesAcceptedByDroppable(accepted);
        }
        this.effect = new Pulsate();
        this.effect.setTimes(2);
        this.effect.setSpeed(250);
        this.add(new Behavior[]{this.effect});
        WTooltip toolTip = new WTooltip("You may drag one of the droppable elements on this page into this rectangle. Otherwise you can drag this rectangle itself and drop it somewhere.").setCssClass("toolTip");
        this.draggable = new DraggableAndDroppableBox(this, "draggableAndDroppable", model);
        this.draggable.add(new Behavior[]{toolTip});
        this.draggable.add(new Behavior[]{this.dragger});
        this.draggable.add(new Behavior[]{this.dropper});
        Component[] componentArray = new Component[1];
        this.l = new Label("theModel", model);
        componentArray[0] = this.l;
        this.draggable.add(componentArray);
        this.l.setOutputMarkupId(true);
        this.add(new Component[]{this.draggable});
        this.setRenderBodyOnly(true);
    }

    public void disableDraggable(AjaxRequestTarget target) {
        this.dragger.disable(target);
    }

    public void enableDraggable(AjaxRequestTarget target) {
        this.dragger.enable(target);
    }

    public void disableDroppable(AjaxRequestTarget target) {
        this.dropper.disable(target);
    }

    public void enableDroppable(AjaxRequestTarget target) {
        this.dropper.enable(target);
    }

    static /* synthetic */ DraggableAndDroppableBox access$000(DraggableAndDroppableElement x0) {
        return x0.draggable;
    }

    static /* synthetic */ Pulsate access$100(DraggableAndDroppableElement x0) {
        return x0.effect;
    }
}

