/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.jwicket.demo;

import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.wicketstuff.jwicket.demo.DraggableAndResizableElement;
import org.wicketstuff.jwicket.demo.GenericPanel;
import org.wicketstuff.jwicket.ui.dragdrop.DraggableBehavior;
import org.wicketstuff.jwicket.ui.resizable.ResizableBehavior;

public class DraggableAndResizableElement
extends GenericPanel<String> {
    private static final long serialVersionUID = 1L;
    protected final Label l;
    private final DraggableBehavior dragger = new DraggableBehavior();
    private final ResizableBehavior resizer;

    public DraggableAndResizableElement(String id) {
        this(id, (IModel)new Model((Serializable)((Object)"Size me!")));
    }

    public DraggableAndResizableElement(String id, IModel<String> model) {
        super(id, model);
        this.dragger.setRevert(DraggableBehavior.DragRevertMode.ALWAYS);
        this.dragger.setDistance(20);
        this.dragger.setWantOnDragStartNotification(true);
        this.dragger.setOpacity(0.99);
        this.dragger.setWantOnDragStopNotification(true);
        this.dragger.setName("one");
        DraggableBox draggable = new DraggableBox(this, "draggable", model);
        draggable.add(new Behavior[]{this.dragger});
        this.resizer = new ResizableBehavior();
        this.resizer.setHandles(new ResizableBehavior.ResizableDirections[]{ResizableBehavior.ResizableDirections.NORTH, ResizableBehavior.ResizableDirections.WEST, ResizableBehavior.ResizableDirections.NORTH_WEST, ResizableBehavior.ResizableDirections.SOUTH_EAST});
        this.resizer.setWantOnResizeNotification(true);
        ResizableBox resizable = new ResizableBox(this, "resizable", model);
        resizable.add(new Behavior[]{this.resizer});
        Component[] componentArray = new Component[1];
        this.l = new Label("theModel", model);
        componentArray[0] = this.l;
        resizable.add(componentArray);
        this.l.setOutputMarkupId(true);
        draggable.add(new Component[]{resizable});
        this.add(new Component[]{draggable});
        this.setRenderBodyOnly(true);
    }

    public void disableDraggable(AjaxRequestTarget target) {
        this.dragger.disable(target);
    }

    public void enableDraggable(AjaxRequestTarget target) {
        this.dragger.enable(target);
    }

    public void disableResizable(AjaxRequestTarget target) {
        this.resizer.disable(target);
    }

    public void enableResizable(AjaxRequestTarget target) {
        this.resizer.enable(target);
    }
}

