/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.jwicket.demo;

import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.wicketstuff.jwicket.CssCursor;
import org.wicketstuff.jwicket.CssPosition;
import org.wicketstuff.jwicket.demo.DraggableElement;
import org.wicketstuff.jwicket.demo.GenericPanel;
import org.wicketstuff.jwicket.tooltip.WalterZornTips;
import org.wicketstuff.jwicket.ui.dragdrop.DraggableBehavior;
import org.wicketstuff.jwicket.ui.effect.Explode;
import org.wicketstuff.jwicket.ui.effect.Puff;

public class DraggableElement
extends GenericPanel<String> {
    private static final long serialVersionUID = 1L;
    private final DraggableLink draggable;
    private final Label l;
    private final Puff effects;
    private final Explode explode;
    private final DraggableBehavior dragger = new DraggableBehavior();

    public DraggableElement(String id) {
        this(id, (IModel)new Model((Serializable)((Object)"Drag me!")));
    }

    public DraggableElement(String id, IModel<String> model) {
        super(id, model);
        this.dragger.setRevert(DraggableBehavior.DragRevertMode.ALWAYS);
        this.dragger.setDistance(20);
        this.dragger.setWantOnDragStartNotification(true);
        this.dragger.setOpacity(0.99);
        this.dragger.setWantOnDragStopNotification(true);
        this.dragger.setName("one");
        this.dragger.setCursor(CssCursor.MOVE).setCursorAt(CssPosition.BOTTOM, 125, CssPosition.RIGHT, 200).setGrid(20, 20).setOpacity(10.5).setSnap(true).setScrollSpeed(200);
        this.effects = new Puff();
        this.effects.setPercen(70);
        this.effects.setSpeed(1200);
        this.add(new Behavior[]{this.effects});
        this.explode = new Explode();
        this.explode.setPieces(16);
        this.explode.setSpeed(1500);
        this.explode.setFadeInAfter(500);
        this.add(new Behavior[]{this.explode});
        WalterZornTips tooltip = new WalterZornTips("This rectangle is draggable!").setShadow(true);
        this.draggable = new DraggableLink(this, "draggableLink", model);
        this.draggable.add(new Behavior[]{tooltip});
        this.draggable.add(new Behavior[]{this.dragger});
        this.draggable.setOutputMarkupId(true);
        Component[] componentArray = new Component[1];
        this.l = new Label("theModel", model);
        componentArray[0] = this.l;
        this.draggable.add(componentArray);
        this.l.setOutputMarkupId(true);
        this.addOrReplace(new Component[]{this.draggable});
    }

    public void disable(AjaxRequestTarget target) {
        this.dragger.disable(target);
    }

    public void enable(AjaxRequestTarget target) {
        this.dragger.enable(target);
    }

    public void test(AjaxRequestTarget target) {
        target.add(new Component[]{this.draggable});
        this.dragger.setCursor(target, CssCursor.MOVE);
        this.dragger.setCursorAt(target, CssPosition.BOTTOM, 125, CssPosition.RIGHT, 200);
        this.dragger.setGrid(target, 150, 150);
        this.dragger.setOpacity(target, 0.3);
        this.dragger.setRevert(target, DraggableBehavior.DragRevertMode.INVALID);
        this.dragger.setSnap(target, true);
        this.dragger.updateBehavior(target);
    }

    static /* synthetic */ DraggableLink access$000(DraggableElement x0) {
        return x0.draggable;
    }

    static /* synthetic */ Puff access$100(DraggableElement x0) {
        return x0.effects;
    }

    static /* synthetic */ Label access$200(DraggableElement x0) {
        return x0.l;
    }

    static /* synthetic */ Explode access$300(DraggableElement x0) {
        return x0.explode;
    }
}

