/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.jwicket.demo;

import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.wicketstuff.jwicket.demo.DroppableElement;
import org.wicketstuff.jwicket.demo.GenericPanel;
import org.wicketstuff.jwicket.tooltip.BeautyTips;
import org.wicketstuff.jwicket.ui.dragdrop.DraggablesAcceptedByDroppable;
import org.wicketstuff.jwicket.ui.dragdrop.DroppableBehavior;
import org.wicketstuff.jwicket.ui.effect.Pulsate;

public class DroppableElement
extends GenericPanel<String> {
    private static final long serialVersionUID = 1L;
    protected final Label l;
    private final Pulsate effects;
    private final DroppableBox droppable;
    private final DroppableBehavior dropper = new DroppableBehavior();

    public DroppableElement(String id) {
        this(id, (IModel)new Model((Serializable)((Object)"Drop it!")), null);
    }

    public DroppableElement(String id, DraggablesAcceptedByDroppable accepted) {
        this(id, (IModel)new Model((Serializable)((Object)"Drop it!")), accepted);
    }

    public DroppableElement(String id, IModel<String> model, DraggablesAcceptedByDroppable accepted) {
        super(id, model);
        this.dropper.setHoverClass("hoverClass");
        this.dropper.setActiveClass("activeClass");
        this.dropper.setTolerance(DroppableBehavior.DropTolerance.TOUCH);
        if (accepted != null) {
            this.dropper.setDraggablesAcceptedByDroppable(accepted);
        }
        this.effects = new Pulsate();
        this.effects.setTimes(2);
        this.effects.setSpeed(250);
        this.add(new Behavior[]{this.effects});
        BeautyTips toolTip = new BeautyTips("You may drag one of the droppable elements on this page into this rectangle.");
        toolTip.setCssClass("toolTip").setActiveClass("toolTippingComponent").setRawOptions("fill:'rgb(80, 80, 80)'").setCornerRadius(3).setSpikeGirth(4);
        this.droppable = new DroppableBox(this, "droppable", model);
        this.droppable.add(new Behavior[]{this.dropper});
        this.droppable.add(new Behavior[]{toolTip});
        Component[] componentArray = new Component[1];
        this.l = new Label("theModel", model);
        componentArray[0] = this.l;
        this.droppable.add(componentArray);
        this.droppable.setOutputMarkupId(true);
        this.l.setOutputMarkupId(true);
        this.add(new Component[]{this.droppable});
        this.setRenderBodyOnly(true);
    }

    public void disable(AjaxRequestTarget target) {
        this.dropper.disable(target);
    }

    public void enable(AjaxRequestTarget target) {
        this.dropper.enable(target);
    }

    static /* synthetic */ DroppableBox access$000(DroppableElement x0) {
        return x0.droppable;
    }

    static /* synthetic */ Pulsate access$100(DroppableElement x0) {
        return x0.effects;
    }
}

