/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.faces.model;

import java.lang.reflect.Method;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.faces.model.SelectionAware;
import org.springframework.faces.webflow.FlowActionListener;
import org.springframework.util.ReflectionUtils;

public class SelectionTrackingActionListener
implements ActionListener {
    private static final Log logger = LogFactory.getLog(FlowActionListener.class);
    private ActionListener delegate;

    public SelectionTrackingActionListener(ActionListener delegate) {
        this.delegate = delegate;
    }

    public void processAction(ActionEvent event) throws AbortProcessingException {
        this.trackSelection(event.getComponent());
        this.delegate.processAction(event);
    }

    private void trackSelection(UIComponent component) {
        UIComponent currentComponent = component;
        while (currentComponent.getParent() != null && !(currentComponent.getParent() instanceof UIViewRoot)) {
            Object value;
            UIComponent parent = currentComponent.getParent();
            Method valueAccessor = ReflectionUtils.findMethod(parent.getClass(), (String)"getValue");
            if (valueAccessor != null && (value = ReflectionUtils.invokeMethod((Method)valueAccessor, (Object)parent)) != null && value instanceof SelectionAware) {
                ((SelectionAware)value).setCurrentRowSelected(true);
                if (!logger.isDebugEnabled()) break;
                logger.debug((Object)"Row selection has been set on the current SelectionAware data model.");
                break;
            }
            currentComponent = currentComponent.getParent();
        }
    }
}

