/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.faces.ui;

import java.io.IOException;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.springframework.faces.ui.BaseSpringJavascriptDecorationRenderer;
import org.springframework.faces.ui.resource.ResourceHelper;
import org.springframework.faces.webflow.JsfUtils;

public class DojoElementDecorationRenderer
extends BaseSpringJavascriptDecorationRenderer {
    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        super.encodeBegin(context, component);
        if (!JsfUtils.isAsynchronousFlowRequest()) {
            if (!context.getViewRoot().getAttributes().containsKey("dojoCustomThemePathSet") && !context.getViewRoot().getAttributes().containsKey("dojoCustomThemeSet")) {
                ResourceHelper.renderStyleLink(context, "/dijit/themes/tundra/tundra.css");
            }
            ResourceHelper.renderScriptLink(context, "/dojo/dojo.js");
            ResourceHelper.renderScriptLink(context, "/spring/Spring-Dojo.js");
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        String selector;
        ResponseWriter writer = context.getResponseWriter();
        if (component.getAttributes().containsKey("selector")) {
            selector = "\"" + (String)component.getAttributes().get("selector") + "\"";
        } else {
            if (component.getChildCount() == 0) {
                throw new FacesException("A Spring Faces elementDecoration expects either have a specified selector or at least one child component.");
            }
            selector = "dojo.byId('" + ((UIComponent)component.getChildren().get(0)).getClientId(context) + "')";
        }
        ResourceHelper.beginScriptBlock(context);
        StringBuffer script = new StringBuffer();
        script.append("  dojo.addOnLoad(function(){dojo.query(" + selector + ").forEach(function(element){");
        script.append("  Spring.addDecoration(new Spring.ElementDecoration({  ");
        script.append("  elementId : element,  ");
        script.append("  widgetType : '" + component.getAttributes().get("widgetType") + "',  ");
        if (component.getAttributes().containsKey("widgetModule")) {
            script.append("  widgetModule : '" + component.getAttributes().get("widgetModule") + "',  ");
        }
        script.append("  widgetAttrs : { ");
        String dojoAttrs = this.getDojoAttributesAsString(context, component);
        script.append(dojoAttrs);
        script.append("  }}));})});");
        writer.writeText((Object)script, null);
        ResourceHelper.endScriptBlock(context);
    }

    protected String getDojoAttributesAsString(FacesContext context, UIComponent component) {
        if (component.getAttributes().containsKey("widgetAttrs")) {
            return (String)component.getAttributes().get("widgetAttrs");
        }
        return "";
    }
}

