/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.faces.webflow;

import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.el.ELContextListener;
import javax.el.ELException;
import javax.el.ELResolver;
import javax.el.ExpressionFactory;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.application.Application;
import javax.faces.application.NavigationHandler;
import javax.faces.application.StateManager;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.el.MethodBinding;
import javax.faces.el.PropertyResolver;
import javax.faces.el.ReferenceSyntaxException;
import javax.faces.el.ValueBinding;
import javax.faces.el.VariableResolver;
import javax.faces.event.ActionListener;
import javax.faces.validator.Validator;
import org.springframework.faces.webflow.FlowViewHandler;
import org.springframework.faces.webflow.FlowViewStateManager;
import org.springframework.faces.webflow.Jsf2FlowViewHandler;
import org.springframework.faces.webflow.JsfRuntimeInformation;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlowApplication
extends Application {
    private Application delegate;

    public FlowApplication(Application delegate) {
        StateManager manager;
        Assert.notNull((Object)delegate, (String)"The delegate Application instance must not be null!");
        this.delegate = delegate;
        ViewHandler handler = this.delegate.getViewHandler();
        if (this.shouldWrap(handler)) {
            this.wrapAndSetViewHandler(handler);
        }
        if (this.shouldWrap(manager = this.delegate.getStateManager())) {
            this.wrapAndSetStateManager(manager);
        }
    }

    public Application getDelegate() {
        return this.delegate;
    }

    public ELContextListener[] getELContextListeners() {
        return this.getDelegate().getELContextListeners();
    }

    public void setStateManager(StateManager manager) {
        if (this.shouldWrap(manager)) {
            this.wrapAndSetStateManager(manager);
        } else {
            this.delegate.setStateManager(manager);
        }
    }

    public void setViewHandler(ViewHandler handler) {
        if (this.shouldWrap(handler)) {
            this.wrapAndSetViewHandler(handler);
        } else {
            this.delegate.setViewHandler(handler);
        }
    }

    public void addComponent(String componentType, String componentClass) {
        this.delegate.addComponent(componentType, componentClass);
    }

    public void addConverter(String converterId, String converterClass) {
        this.delegate.addConverter(converterId, converterClass);
    }

    public void addConverter(Class<?> targetClass, String converterClass) {
        this.delegate.addConverter(targetClass, converterClass);
    }

    public void addELContextListener(ELContextListener listener) {
        this.getDelegate().addELContextListener(listener);
    }

    public void addELResolver(ELResolver resolver) {
        this.getDelegate().addELResolver(resolver);
    }

    public void addValidator(String validatorId, String validatorClass) {
        this.delegate.addValidator(validatorId, validatorClass);
    }

    public UIComponent createComponent(String componentType) throws FacesException {
        return this.delegate.createComponent(componentType);
    }

    public UIComponent createComponent(ValueBinding componentBinding, FacesContext context, String componentType) throws FacesException {
        return this.delegate.createComponent(componentBinding, context, componentType);
    }

    public UIComponent createComponent(ValueExpression componentExpression, FacesContext context, String componentType) throws FacesException {
        return this.getDelegate().createComponent(componentExpression, context, componentType);
    }

    public Converter createConverter(String converterId) {
        return this.delegate.createConverter(converterId);
    }

    public Converter createConverter(Class<?> targetClass) {
        return this.delegate.createConverter(targetClass);
    }

    public MethodBinding createMethodBinding(String ref, Class<?>[] params) throws ReferenceSyntaxException {
        return this.delegate.createMethodBinding(ref, (Class[])params);
    }

    public Validator createValidator(String validatorId) throws FacesException {
        return this.delegate.createValidator(validatorId);
    }

    public ValueBinding createValueBinding(String ref) throws ReferenceSyntaxException {
        return this.delegate.createValueBinding(ref);
    }

    public <T> T evaluateExpressionGet(FacesContext context, String expression, Class<? extends T> expectedType) throws ELException {
        return (T)this.getDelegate().evaluateExpressionGet(context, expression, expectedType);
    }

    public ActionListener getActionListener() {
        return this.delegate.getActionListener();
    }

    public Iterator<String> getComponentTypes() {
        return this.delegate.getComponentTypes();
    }

    public Iterator<String> getConverterIds() {
        return this.delegate.getConverterIds();
    }

    public Iterator<Class<?>> getConverterTypes() {
        return this.delegate.getConverterTypes();
    }

    public Locale getDefaultLocale() {
        return this.delegate.getDefaultLocale();
    }

    public String getDefaultRenderKitId() {
        return this.delegate.getDefaultRenderKitId();
    }

    public ELResolver getELResolver() {
        return this.getDelegate().getELResolver();
    }

    public ExpressionFactory getExpressionFactory() {
        return this.getDelegate().getExpressionFactory();
    }

    public String getMessageBundle() {
        return this.delegate.getMessageBundle();
    }

    public NavigationHandler getNavigationHandler() {
        return this.delegate.getNavigationHandler();
    }

    public PropertyResolver getPropertyResolver() {
        return this.delegate.getPropertyResolver();
    }

    public ResourceBundle getResourceBundle(FacesContext ctx, String name) {
        return this.getDelegate().getResourceBundle(ctx, name);
    }

    public StateManager getStateManager() {
        return this.delegate.getStateManager();
    }

    public Iterator<Locale> getSupportedLocales() {
        return this.delegate.getSupportedLocales();
    }

    public Iterator<String> getValidatorIds() {
        return this.delegate.getValidatorIds();
    }

    public VariableResolver getVariableResolver() {
        return this.delegate.getVariableResolver();
    }

    public ViewHandler getViewHandler() {
        return this.delegate.getViewHandler();
    }

    public void removeELContextListener(ELContextListener listener) {
        this.getDelegate().removeELContextListener(listener);
    }

    public void setActionListener(ActionListener listener) {
        this.delegate.setActionListener(listener);
    }

    public void setDefaultLocale(Locale locale) {
        this.delegate.setDefaultLocale(locale);
    }

    public void setDefaultRenderKitId(String renderKitId) {
        this.delegate.setDefaultRenderKitId(renderKitId);
    }

    public void setMessageBundle(String bundle) {
        this.delegate.setMessageBundle(bundle);
    }

    public void setNavigationHandler(NavigationHandler handler) {
        this.delegate.setNavigationHandler(handler);
    }

    public void setPropertyResolver(PropertyResolver resolver) {
        this.delegate.setPropertyResolver(resolver);
    }

    public void setSupportedLocales(Collection<Locale> locales) {
        this.delegate.setSupportedLocales(locales);
    }

    public void setVariableResolver(VariableResolver resolver) {
        this.delegate.setVariableResolver(resolver);
    }

    private boolean shouldWrap(ViewHandler delegateViewHandler) {
        return delegateViewHandler != null && !(delegateViewHandler instanceof FlowViewHandler);
    }

    private boolean wrapAndSetViewHandler(ViewHandler target) {
        if (target != null && !(target instanceof FlowViewHandler)) {
            FlowViewHandler handler = JsfRuntimeInformation.isAtLeastJsf20() ? new Jsf2FlowViewHandler(target) : new FlowViewHandler(target);
            this.delegate.setViewHandler((ViewHandler)handler);
            return true;
        }
        return false;
    }

    private boolean shouldWrap(StateManager manager) {
        return manager != null && !(manager instanceof FlowViewStateManager);
    }

    private void wrapAndSetStateManager(StateManager target) {
        this.delegate.setStateManager((StateManager)new FlowViewStateManager(target));
    }
}

