/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.faces.webflow;

import java.io.IOException;
import java.io.Writer;
import javax.faces.application.StateManager;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.ResponseStateManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.faces.webflow.FlowSerializedView;
import org.springframework.faces.webflow.JsfUtils;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.RequestContextHolder;

public class FlowViewResponseStateManager
extends ResponseStateManager {
    private static final Log logger = LogFactory.getLog(FlowViewResponseStateManager.class);
    private ResponseStateManager delegate;
    private char[] stateFieldStart = "<input type=\"hidden\" name=\"javax.faces.ViewState\" id=\"javax.faces.ViewState\" value=\"".toCharArray();
    private char[] stateFieldEnd = "\" />".toCharArray();

    public FlowViewResponseStateManager(ResponseStateManager delegate) {
        this.delegate = delegate;
    }

    public void writeState(FacesContext facesContext, Object state) throws IOException {
        if (!JsfUtils.isFlowRequest()) {
            this.delegate.writeState(facesContext, state);
        } else {
            FlowSerializedView view = null;
            if (state instanceof FlowSerializedView) {
                view = (FlowSerializedView)state;
            } else {
                Object[] serializedState = (Object[])state;
                view = new FlowSerializedView(facesContext.getViewRoot().getViewId(), serializedState[0], serializedState[1]);
            }
            RequestContext requestContext = RequestContextHolder.getRequestContext();
            requestContext.getViewScope().put("flowSerializedViewState", (Object)view);
            ResponseWriter writer = facesContext.getResponseWriter();
            this.writeViewStateField(facesContext, (Writer)writer);
            this.writeRenderKitIdField(facesContext, writer);
        }
    }

    public Object getState(FacesContext facesContext, String viewId) {
        if (!JsfUtils.isFlowRequest()) {
            return this.delegate.getState(facesContext, viewId);
        }
        RequestContext requestContext = RequestContextHolder.getRequestContext();
        FlowSerializedView view = (FlowSerializedView)requestContext.getViewScope().get("flowSerializedViewState");
        Object[] state = null;
        if (view == null) {
            logger.debug((Object)"No matching view in view scope");
        } else {
            state = new Object[]{view.getTreeStructure(), view.getComponentState()};
        }
        return state;
    }

    public String getViewState(FacesContext facesContext, Object state) {
        if (!JsfUtils.isFlowRequest()) {
            return this.delegate.getViewState(facesContext, state);
        }
        return this.getFlowExecutionKey();
    }

    public boolean isPostback(FacesContext context) {
        return this.delegate.isPostback(context);
    }

    public Object getTreeStructureToRestore(FacesContext context, String viewId) {
        return this.delegate.getTreeStructureToRestore(context, viewId);
    }

    public Object getComponentStateToRestore(FacesContext context) {
        return this.delegate.getComponentStateToRestore(context);
    }

    public void writeState(FacesContext context, StateManager.SerializedView state) throws IOException {
        this.delegate.writeState(context, state);
    }

    private String getFlowExecutionKey() {
        RequestContext requestContext = RequestContextHolder.getRequestContext();
        return requestContext.getFlowExecutionContext().getKey().toString();
    }

    private void writeViewStateField(FacesContext context, Writer writer) throws IOException {
        writer.write(this.stateFieldStart);
        writer.write(this.getFlowExecutionKey());
        writer.write(this.stateFieldEnd);
    }

    private void writeRenderKitIdField(FacesContext context, ResponseWriter writer) throws IOException {
        String result = context.getApplication().getDefaultRenderKitId();
        if (result != null && !"HTML_BASIC".equals(result)) {
            writer.startElement("input", (UIComponent)context.getViewRoot());
            writer.writeAttribute("type", (Object)"hidden", "type");
            writer.writeAttribute("name", (Object)"javax.faces.RenderKitId", "name");
            writer.writeAttribute("value", (Object)result, "value");
            writer.endElement("input");
        }
    }
}

