/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.faces.webflow;

import java.util.Iterator;
import javax.faces.application.ViewHandler;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.faces.event.PhaseId;
import javax.faces.lifecycle.Lifecycle;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.binding.expression.Expression;
import org.springframework.faces.ui.AjaxViewRoot;
import org.springframework.faces.webflow.FlowFacesContext;
import org.springframework.faces.webflow.JsfRuntimeInformation;
import org.springframework.faces.webflow.JsfUtils;
import org.springframework.faces.webflow.JsfView;
import org.springframework.js.ajax.SpringJavascriptAjaxHandler;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.View;
import org.springframework.webflow.execution.ViewFactory;

public class JsfViewFactory
implements ViewFactory {
    private static final Log logger = LogFactory.getLog(JsfViewFactory.class);
    private static SpringJavascriptAjaxHandler springJsAjaxHandler = new SpringJavascriptAjaxHandler();
    private final Expression viewIdExpression;
    private final Lifecycle lifecycle;

    public JsfViewFactory(Expression viewIdExpression, Lifecycle lifecycle) {
        this.viewIdExpression = viewIdExpression;
        this.lifecycle = lifecycle;
    }

    public View getView(RequestContext context) {
        JsfView view;
        String viewName;
        FacesContext facesContext = FlowFacesContext.getCurrentInstance();
        if (facesContext == null) {
            throw new IllegalStateException("FacesContext has not been initialized within the current Web Flow request. Check the configuration for your <webflow:flow-executor>. For JSF you will need FlowFacesContextLifecycleListener configured as one of its flow execution listeners.");
        }
        if (JsfRuntimeInformation.isAtLeastJsf20()) {
            facesContext.setCurrentPhaseId(PhaseId.RESTORE_VIEW);
        }
        if (!facesContext.getRenderResponse()) {
            JsfUtils.notifyBeforeListeners(PhaseId.RESTORE_VIEW, this.lifecycle, facesContext);
        }
        ViewHandler viewHandler = facesContext.getApplication().getViewHandler();
        if (JsfRuntimeInformation.isAtLeastJsf12() && !JsfRuntimeInformation.isPortletRequest(facesContext)) {
            viewHandler.initView(facesContext);
        }
        if (this.viewAlreadySet(facesContext, viewName = (String)this.viewIdExpression.getValue((Object)context))) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Existing view root found with id '" + facesContext.getViewRoot().getId() + "'"));
            }
            UIViewRoot viewRoot = facesContext.getViewRoot();
            viewRoot.setLocale(context.getExternalContext().getLocale());
            this.processTree(facesContext, (UIComponent)viewRoot);
            view = this.createJsfView(facesContext.getViewRoot(), this.lifecycle, context);
        } else if (context.inViewState()) {
            UIViewRoot viewRoot = viewHandler.restoreView(facesContext, viewName);
            if (viewRoot != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("UIViewRoot restored for '" + viewName + "'"));
                }
                facesContext.setViewRoot(viewRoot);
                this.processTree(facesContext, (UIComponent)viewRoot);
                view = this.createJsfView(viewRoot, this.lifecycle, context);
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Creating UIViewRoot from '" + viewName + "'"));
                }
                viewRoot = viewHandler.createView(facesContext, viewName);
                facesContext.setViewRoot(viewRoot);
                view = this.createJsfView(viewRoot, this.lifecycle, context);
            }
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Creating transient UIViewRoot from '" + viewName + "'"));
            }
            UIViewRoot viewRoot = viewHandler.createView(facesContext, viewName);
            viewRoot.setTransient(true);
            facesContext.setViewRoot(viewRoot);
            view = this.createJsfView(viewRoot, this.lifecycle, context);
        }
        if (JsfRuntimeInformation.isAtLeastJsf20()) {
            JsfUtils.publishPostRestoreStateEvent();
        }
        if (!facesContext.getRenderResponse()) {
            JsfUtils.notifyAfterListeners(PhaseId.RESTORE_VIEW, this.lifecycle, facesContext);
        }
        return view;
    }

    private boolean viewAlreadySet(FacesContext facesContext, String viewName) {
        return facesContext.getViewRoot() != null && facesContext.getViewRoot().getViewId().equals(viewName);
    }

    private JsfView createJsfView(UIViewRoot root, Lifecycle lifecycle, RequestContext context) {
        if (this.isSpringJavascriptAjaxRequest(context.getExternalContext())) {
            root = new AjaxViewRoot(root);
        }
        return new JsfView(root, lifecycle, context);
    }

    private boolean isSpringJavascriptAjaxRequest(ExternalContext context) {
        if (context.getNativeContext() instanceof ServletContext) {
            return springJsAjaxHandler.isAjaxRequest((HttpServletRequest)context.getNativeRequest(), (HttpServletResponse)context.getNativeResponse());
        }
        return false;
    }

    private void processTree(FacesContext context, UIComponent component) {
        ValueBinding binding;
        if (!context.getRenderResponse() && component instanceof EditableValueHolder) {
            ((EditableValueHolder)component).setValid(true);
        }
        if ((binding = component.getValueBinding("binding")) != null) {
            binding.setValue(context, (Object)component);
        }
        Iterator it = component.getFacetsAndChildren();
        while (it.hasNext()) {
            UIComponent child = (UIComponent)it.next();
            this.processTree(context, child);
        }
    }
}

